/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp;

import com.couchbase.client.core.utils.DefaultObjectMapper;
import com.couchbase.client.dcp.ClientVersion;
import com.couchbase.client.dcp.ConnectionNameGenerator;
import com.couchbase.client.dcp.util.UserAgentBuilder;
import com.couchbase.client.deps.com.fasterxml.jackson.core.JsonProcessingException;
import java.util.LinkedHashMap;
import java.util.concurrent.ThreadLocalRandom;

public class DefaultConnectionNameGenerator
implements ConnectionNameGenerator {
    public static final ConnectionNameGenerator INSTANCE = new DefaultConnectionNameGenerator(new UserAgentBuilder());
    private static final String clientId = DefaultConnectionNameGenerator.paddedHex(DefaultConnectionNameGenerator.randomLong());
    private final String userAgent;

    public static DefaultConnectionNameGenerator forProduct(String productName, String productVersion, String ... comments) {
        return new DefaultConnectionNameGenerator(new UserAgentBuilder().append(productName, productVersion, comments));
    }

    private DefaultConnectionNameGenerator(UserAgentBuilder userAgentBuilder) {
        userAgentBuilder.append("java-dcp-client", ClientVersion.clientVersion(), new String[0]).appendJava().appendOs();
        boolean WORKAROUND_CBSE_6804 = true;
        int userAgentMaxLength = 102;
        this.userAgent = DefaultConnectionNameGenerator.truncateAsJson(userAgentBuilder.build(), 102);
    }

    @Override
    public String name() {
        String connectionId = DefaultConnectionNameGenerator.paddedHex(DefaultConnectionNameGenerator.randomLong());
        LinkedHashMap<String, String> name = new LinkedHashMap<String, String>();
        name.put("i", clientId + "/" + connectionId);
        name.put("a", this.userAgent);
        try {
            return DefaultObjectMapper.writeValueAsString(name);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    private static String truncateAsJson(String s, int maxSerializedLength) {
        char c;
        boolean charNeedsEscape;
        int resultLength = 0;
        int spaceLeft = maxSerializedLength - 2;
        char[] cArray = s.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n && (spaceLeft -= (charNeedsEscape = (c = cArray[i]) == '\\' || c == '\"' || c == '\t') ? 2 : 1) >= 0; ++i) {
            ++resultLength;
        }
        return DefaultConnectionNameGenerator.truncate(s, resultLength);
    }

    private static String truncate(String s, int maxLength) {
        return s.length() <= maxLength ? s : s.substring(0, maxLength);
    }

    private static String paddedHex(long number) {
        return String.format("%016X", number);
    }

    private static long randomLong() {
        return ThreadLocalRandom.current().nextLong();
    }
}

