/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.buffer;

import com.couchbase.client.core.CouchbaseException;
import com.couchbase.client.core.config.AlternateAddress;
import com.couchbase.client.core.config.CouchbaseBucketConfig;
import com.couchbase.client.core.config.DefaultNodeInfo;
import com.couchbase.client.core.config.NodeInfo;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.service.ServiceType;
import com.couchbase.client.dcp.buffer.NodeToPartitionMultimap;
import com.couchbase.client.dcp.buffer.PartitionInstance;
import com.couchbase.client.dcp.config.HostAndPort;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.stream.Collectors;

public class DcpBucketConfig {
    private final boolean sslEnabled;
    private final CouchbaseBucketConfig config;
    private final NodeToPartitionMultimap map;
    private final List<NodeInfo> dataNodesWithAnyPartitions;
    private final List<NodeInfo> dataNodesWithActivePartitions;
    private final List<NodeInfo> allNodes;

    public DcpBucketConfig(CouchbaseBucketConfig config, boolean sslEnabled) {
        this.config = Objects.requireNonNull(config);
        this.sslEnabled = sslEnabled;
        this.map = new NodeToPartitionMultimap(config);
        this.allNodes = DcpBucketConfig.resolveAlternateAddresses(config);
        ArrayList<NodeInfo> active = new ArrayList<NodeInfo>();
        ArrayList<NodeInfo> activeOrReplica = new ArrayList<NodeInfo>();
        int len = this.allNodes.size();
        for (int i = 0; i < len; ++i) {
            boolean hasAnyPartitions;
            NodeInfo node = this.allNodes.get(i);
            boolean bl = hasAnyPartitions = !this.map.get(i).isEmpty();
            if (!hasAnyPartitions) continue;
            if (!this.hasBinaryService(node)) {
                throw new IllegalArgumentException("Only nodes running the KV service can host bucket partitions.");
            }
            activeOrReplica.add(node);
            boolean nodeHasActivePartitions = this.map.get(i).stream().anyMatch(partitionInstance -> partitionInstance.slot() == 0);
            if (!nodeHasActivePartitions) continue;
            active.add(node);
        }
        this.dataNodesWithAnyPartitions = Collections.unmodifiableList(activeOrReplica);
        this.dataNodesWithActivePartitions = Collections.unmodifiableList(active);
    }

    public long rev() {
        return this.config.rev();
    }

    public int numberOfPartitions() {
        return this.config.numberOfPartitions();
    }

    public List<NodeInfo> nodes() {
        return this.allNodes;
    }

    private static List<NodeInfo> resolveAlternateAddresses(CouchbaseBucketConfig config) {
        return config.nodes().stream().map(DcpBucketConfig::resolveAlternateAddress).collect(Collectors.toList());
    }

    private static NodeInfo resolveAlternateAddress(NodeInfo nodeInfo) {
        String networkName = nodeInfo.useAlternateNetwork();
        if (networkName == null) {
            return nodeInfo;
        }
        AlternateAddress alternate = (AlternateAddress)nodeInfo.alternateAddresses().get(networkName);
        if (alternate == null) {
            throw new CouchbaseException("Node " + RedactableArgument.system((Object)nodeInfo.hostname()) + " has no alternate hostname for network [" + networkName + "]");
        }
        HashMap services = new HashMap(nodeInfo.services());
        HashMap sslServices = new HashMap(nodeInfo.sslServices());
        services.putAll(alternate.services());
        sslServices.putAll(alternate.sslServices());
        return new DefaultNodeInfo(alternate.hostname(), services, sslServices, Collections.emptyMap());
    }

    public List<PartitionInstance> getHostedPartitions(InetSocketAddress nodeAddress) throws NoSuchElementException {
        int nodeIndex = this.getNodeIndex(nodeAddress);
        return this.map.get(nodeIndex);
    }

    public List<NodeInfo> getDataNodes(boolean requireActivePartition) {
        return requireActivePartition ? this.dataNodesWithActivePartitions : this.dataNodesWithAnyPartitions;
    }

    public int getNodeIndex(InetSocketAddress nodeAddress) throws NoSuchElementException {
        int nodeIndex = 0;
        for (NodeInfo node : this.nodes()) {
            if (nodeAddress.equals(this.getAddress(node))) {
                return nodeIndex;
            }
            ++nodeIndex;
        }
        throw new NoSuchElementException("Failed to locate " + RedactableArgument.system((Object)nodeAddress) + " in bucket config.");
    }

    public HostAndPort getMasterNodeKvAddress(int partition) {
        short index = this.config.nodeIndexForMaster(partition, false);
        NodeInfo node = this.nodes().get(index);
        int port = this.getServicePortMap(node).get(ServiceType.BINARY);
        return new HostAndPort(node.hostname(), port);
    }

    public List<PartitionInstance> getAbsentPartitionInstances() {
        return this.map.getAbsent();
    }

    public InetSocketAddress getAddress(NodeInfo node) {
        int port = this.getServicePortMap(node).get(ServiceType.BINARY);
        return new InetSocketAddress(node.hostname(), port);
    }

    private Map<ServiceType, Integer> getServicePortMap(NodeInfo node) {
        return this.sslEnabled ? node.sslServices() : node.services();
    }

    private boolean hasBinaryService(NodeInfo node) {
        return this.getServicePortMap(node).containsKey(ServiceType.BINARY);
    }

    public int numberOfReplicas() {
        return this.config.numberOfReplicas();
    }
}

