/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.buffer;

import com.couchbase.client.dcp.buffer.DcpOps;
import com.couchbase.client.dcp.buffer.DcpRequestDispatcher;
import com.couchbase.client.dcp.buffer.FailoverLogResponse;
import com.couchbase.client.dcp.buffer.ObserveSeqnoResponse;
import com.couchbase.client.dcp.message.MessageUtil;
import com.couchbase.client.dcp.message.ResponseStatus;
import com.couchbase.client.dcp.transport.netty.DcpResponse;
import com.couchbase.client.dcp.transport.netty.DcpResponseListener;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.deps.io.netty.util.ReferenceCountUtil;
import com.couchbase.client.deps.io.netty.util.concurrent.Future;
import com.couchbase.client.deps.io.netty.util.concurrent.GenericFutureListener;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import rx.Single;
import rx.SingleEmitter;
import rx.functions.Action1;

public class DcpOpsImpl
implements DcpOps {
    private final DcpRequestDispatcher dispatcher;

    public DcpOpsImpl(DcpRequestDispatcher dispatcher) {
        this.dispatcher = Objects.requireNonNull(dispatcher);
    }

    @Override
    public Single<ObserveSeqnoResponse> observeSeqno(int partition, long vbuuid) {
        return this.doRequest(() -> DcpRequestBuilder.request((byte)-111).vbucket(partition).content(Unpooled.buffer((int)8).writeLong(vbuuid)), ObserveSeqnoResponse::new);
    }

    @Override
    public Single<FailoverLogResponse> getFailoverLog(int partition) {
        return this.doRequest(() -> DcpRequestBuilder.request((byte)84).vbucket(partition), FailoverLogResponse::new);
    }

    private <R> Single<R> doRequest(final Supplier<DcpRequestBuilder> requestBuilder, final Function<ByteBuf, R> resultExtractor) {
        return Single.fromEmitter((Action1)new Action1<SingleEmitter<R>>(){

            public void call(final SingleEmitter<R> singleEmitter) {
                try {
                    ByteBuf request = ((DcpRequestBuilder)requestBuilder.get()).build();
                    DcpOpsImpl.this.dispatcher.sendRequest(request).addListener((GenericFutureListener)new DcpResponseListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void operationComplete(Future<DcpResponse> future) throws Exception {
                            if (!future.isSuccess()) {
                                singleEmitter.onError(future.cause());
                                return;
                            }
                            ByteBuf buf = ((DcpResponse)future.getNow()).buffer();
                            try {
                                ResponseStatus status = MessageUtil.getResponseStatus(buf);
                                if (!status.isSuccess()) {
                                    throw new DcpOps.BadResponseStatusException(status);
                                }
                                Object result = resultExtractor.apply(buf);
                                singleEmitter.onSuccess(result);
                            }
                            catch (Throwable t) {
                                singleEmitter.onError(t);
                            }
                            finally {
                                buf.release();
                            }
                        }
                    });
                }
                catch (Throwable t) {
                    singleEmitter.onError(t);
                }
            }
        });
    }

    static class DcpRequestBuilder {
        private final byte opcode;
        private short vbucket;
        private ByteBuf content;
        private boolean used;

        private DcpRequestBuilder(byte opcode) {
            this.opcode = opcode;
        }

        static DcpRequestBuilder request(byte opcode) {
            return new DcpRequestBuilder(opcode);
        }

        DcpRequestBuilder vbucket(int vbucket) {
            this.vbucket = (short)vbucket;
            return this;
        }

        DcpRequestBuilder content(ByteBuf content) {
            this.content = content;
            return this;
        }

        ByteBuf build() {
            if (this.used) {
                throw new IllegalStateException("Not reusable");
            }
            try {
                ByteBuf buf = Unpooled.buffer();
                MessageUtil.initRequest(this.opcode, buf);
                MessageUtil.setVbucket(this.vbucket, buf);
                if (this.content != null) {
                    MessageUtil.setContent(this.content, buf);
                }
                ByteBuf byteBuf = buf;
                return byteBuf;
            }
            finally {
                this.used = true;
                ReferenceCountUtil.release((Object)this.content);
            }
        }
    }
}

