/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.buffer;

import com.couchbase.client.core.config.CouchbaseBucketConfig;
import com.couchbase.client.dcp.buffer.PartitionInstance;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class NodeToPartitionMultimap {
    private final Map<Integer, List<PartitionInstance>> nodeIndexToHostedPartitions = new HashMap<Integer, List<PartitionInstance>>();

    NodeToPartitionMultimap(CouchbaseBucketConfig bucketConfig) {
        for (short partition = 0; partition < bucketConfig.numberOfPartitions(); partition = (short)(partition + 1)) {
            this.put(bucketConfig.nodeIndexForMaster((int)partition, false), new PartitionInstance(partition, 0));
            for (int r = 0; r < bucketConfig.numberOfReplicas(); ++r) {
                this.put(bucketConfig.nodeIndexForReplica((int)partition, r, false), new PartitionInstance(partition, r + 1));
            }
        }
        NodeToPartitionMultimap.freezeValues(this.nodeIndexToHostedPartitions);
    }

    private static <K, V> void freezeValues(Map<K, List<V>> map) {
        for (Map.Entry<K, List<List<V>>> entry : map.entrySet()) {
            entry.setValue(Collections.unmodifiableList(entry.getValue()));
        }
    }

    private void put(int nodeIndex, PartitionInstance partition) {
        List hostedPartitions = this.nodeIndexToHostedPartitions.computeIfAbsent(nodeIndex, k -> new ArrayList(4));
        hostedPartitions.add(partition);
    }

    List<PartitionInstance> get(int nodeIndex) {
        return this.nodeIndexToHostedPartitions.getOrDefault(nodeIndex, Collections.emptyList());
    }

    List<PartitionInstance> getAbsent() {
        ArrayList<PartitionInstance> absentPartitions = new ArrayList<PartitionInstance>();
        for (Map.Entry<Integer, List<PartitionInstance>> e : this.nodeIndexToHostedPartitions.entrySet()) {
            if (e.getKey() >= 0) continue;
            absentPartitions.addAll((Collection<PartitionInstance>)e.getValue());
        }
        return absentPartitions;
    }

    public String toString() {
        return this.nodeIndexToHostedPartitions.toString();
    }
}

