/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.buffer;

import com.couchbase.client.dcp.buffer.DcpBucketConfig;
import com.couchbase.client.dcp.buffer.PartitionInstance;
import com.couchbase.client.dcp.util.MathUtils;
import java.util.Arrays;

public class PersistedSeqnos {
    private PartitionInfo[] partitionInfo;

    private PersistedSeqnos(int numPartitions, int numReplicas) {
        this.reset(numPartitions, numReplicas);
    }

    public static PersistedSeqnos uninitialized() {
        return new PersistedSeqnos(0, 0);
    }

    public synchronized long update(PartitionInstance partitionInstance, long vbuuid, long seqno) {
        return this.update(partitionInstance.partition(), partitionInstance.slot(), vbuuid, seqno);
    }

    public synchronized long update(short partition, int slot, long vbuuid, long seqno) {
        VbuuidAndSeqno vbuuidAndSeqno = this.partitionInfo[partition].get(slot);
        vbuuidAndSeqno.vbuuid = vbuuid;
        vbuuidAndSeqno.seqno = seqno;
        return this.persistedSeqnoForPartition(partition);
    }

    public synchronized void markAsAbsent(PartitionInstance absentInstance) {
        this.partitionInfo[absentInstance.partition()].get(absentInstance.slot()).absent = true;
    }

    public synchronized void reset(DcpBucketConfig bucketConfig) {
        this.reset(bucketConfig.numberOfPartitions(), bucketConfig.numberOfReplicas());
    }

    public synchronized void reset(int numPartitions, int numReplicas) {
        this.partitionInfo = new PartitionInfo[numPartitions];
        for (int i = 0; i < this.partitionInfo.length; ++i) {
            this.partitionInfo[i] = new PartitionInfo(numReplicas);
        }
    }

    private synchronized long persistedSeqnoForPartition(int partition) {
        return this.partitionInfo[partition].persistedSeqno();
    }

    public synchronized String toString() {
        return Arrays.toString(this.partitionInfo);
    }

    private static class PartitionInfo {
        private final VbuuidAndSeqno[] vbuuidAndSeqnos;

        PartitionInfo(int numReplicas) {
            this.vbuuidAndSeqnos = new VbuuidAndSeqno[numReplicas + 1];
            for (int i = 0; i < this.vbuuidAndSeqnos.length; ++i) {
                this.vbuuidAndSeqnos[i] = new VbuuidAndSeqno();
            }
        }

        public VbuuidAndSeqno get(int slot) {
            return this.vbuuidAndSeqnos[slot];
        }

        public String toString() {
            return Arrays.toString(this.vbuuidAndSeqnos) + "=" + this.persistedSeqno();
        }

        private long persistedSeqno() {
            int i = this.indexOfFirstPresentPartitionInstance();
            if (i == -1) {
                return 0L;
            }
            long vbuuid = this.vbuuidAndSeqnos[i].vbuuid;
            long minSeqno = this.vbuuidAndSeqnos[i].seqno;
            ++i;
            while (i < this.vbuuidAndSeqnos.length) {
                VbuuidAndSeqno vbuuidAndSeqno = this.vbuuidAndSeqnos[i];
                if (!vbuuidAndSeqno.absent) {
                    if (vbuuid != vbuuidAndSeqno.vbuuid) {
                        return 0L;
                    }
                    if (MathUtils.lessThanUnsigned(vbuuidAndSeqno.seqno, minSeqno)) {
                        minSeqno = this.vbuuidAndSeqnos[i].seqno;
                    }
                }
                ++i;
            }
            return minSeqno;
        }

        private int indexOfFirstPresentPartitionInstance() {
            for (int i = 0; i < this.vbuuidAndSeqnos.length; ++i) {
                if (this.vbuuidAndSeqnos[i].absent) continue;
                return i;
            }
            return -1;
        }
    }

    private static class VbuuidAndSeqno {
        private long vbuuid;
        private long seqno;
        private boolean absent;

        private VbuuidAndSeqno() {
        }

        public String toString() {
            return this.seqno + "@" + Long.toHexString(this.vbuuid);
        }
    }
}

