/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.conductor;

import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.core.state.AbstractStateMachine;
import com.couchbase.client.core.state.LifecycleState;
import com.couchbase.client.core.state.NotConnectedException;
import com.couchbase.client.core.time.Delay;
import com.couchbase.client.dcp.conductor.Conductor;
import com.couchbase.client.dcp.conductor.DcpChannelControlHandler;
import com.couchbase.client.dcp.conductor.NotMyVbucketException;
import com.couchbase.client.dcp.config.ClientEnvironment;
import com.couchbase.client.dcp.error.RollbackException;
import com.couchbase.client.dcp.message.DcpCloseStreamRequest;
import com.couchbase.client.dcp.message.DcpFailoverLogRequest;
import com.couchbase.client.dcp.message.DcpFailoverLogResponse;
import com.couchbase.client.dcp.message.DcpGetPartitionSeqnosRequest;
import com.couchbase.client.dcp.message.DcpOpenStreamRequest;
import com.couchbase.client.dcp.message.DcpOpenStreamResponse;
import com.couchbase.client.dcp.message.MessageUtil;
import com.couchbase.client.dcp.message.ResponseStatus;
import com.couchbase.client.dcp.message.RollbackMessage;
import com.couchbase.client.dcp.message.VbucketState;
import com.couchbase.client.dcp.transport.netty.ChannelFlowController;
import com.couchbase.client.dcp.transport.netty.ChannelUtils;
import com.couchbase.client.dcp.transport.netty.DcpMessageHandler;
import com.couchbase.client.dcp.transport.netty.DcpPipeline;
import com.couchbase.client.dcp.transport.netty.DcpResponse;
import com.couchbase.client.dcp.transport.netty.DcpResponseListener;
import com.couchbase.client.dcp.util.AdaptiveDelay;
import com.couchbase.client.dcp.util.AtomicBooleanArray;
import com.couchbase.client.dcp.util.retry.RetryBuilder;
import com.couchbase.client.deps.io.netty.bootstrap.Bootstrap;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.deps.io.netty.buffer.PooledByteBufAllocator;
import com.couchbase.client.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.deps.io.netty.buffer.UnpooledByteBufAllocator;
import com.couchbase.client.deps.io.netty.channel.Channel;
import com.couchbase.client.deps.io.netty.channel.ChannelFuture;
import com.couchbase.client.deps.io.netty.channel.ChannelFutureListener;
import com.couchbase.client.deps.io.netty.channel.ChannelHandler;
import com.couchbase.client.deps.io.netty.channel.ChannelOption;
import com.couchbase.client.deps.io.netty.util.ReferenceCountUtil;
import com.couchbase.client.deps.io.netty.util.concurrent.Future;
import com.couchbase.client.deps.io.netty.util.concurrent.GenericFutureListener;
import com.couchbase.client.deps.io.netty.util.concurrent.ImmediateEventExecutor;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import rx.Completable;
import rx.CompletableSubscriber;
import rx.Single;
import rx.SingleSubscriber;
import rx.Subscription;
import rx.functions.Action4;
import rx.functions.Func1;

public class DcpChannel
extends AbstractStateMachine<LifecycleState> {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(DcpChannel.class);
    private static final ChannelFlowController dummyFlowController = new ChannelFlowController(){

        @Override
        public void ack(ByteBuf message) {
        }

        @Override
        public void ack(int numBytes) {
        }
    };
    private final DcpChannelControlHandler controlHandler;
    private volatile boolean isShutdown;
    private volatile Channel channel;
    private volatile ChannelFuture connectFuture;
    private final AdaptiveDelay reconnectDelay = new AdaptiveDelay(Delay.exponential((TimeUnit)TimeUnit.MILLISECONDS, (long)4096L, (long)32L), Duration.ofSeconds(10L));
    final ClientEnvironment env;
    final InetSocketAddress inetAddress;
    final AtomicBooleanArray streamIsOpen = new AtomicBooleanArray(1024);
    final Conductor conductor;

    public DcpChannel(InetSocketAddress inetAddress, ClientEnvironment env, Conductor conductor) {
        super((Enum)LifecycleState.DISCONNECTED);
        this.inetAddress = inetAddress;
        this.env = env;
        this.conductor = conductor;
        this.controlHandler = new DcpChannelControlHandler(this);
        this.isShutdown = false;
    }

    public Future<DcpResponse> sendRequest(ByteBuf message) {
        if (this.channel == null) {
            ReferenceCountUtil.safeRelease((Object)message);
            return ImmediateEventExecutor.INSTANCE.newFailedFuture((Throwable)new NotConnectedException("Failed to issue request; channel is not active."));
        }
        return ((DcpMessageHandler)this.channel.pipeline().get(DcpMessageHandler.class)).sendRequest(message);
    }

    public Completable connect() {
        return Completable.create((Completable.OnSubscribe)new Completable.OnSubscribe(){

            public void call(final CompletableSubscriber subscriber) {
                if (DcpChannel.this.isShutdown || DcpChannel.this.state() != LifecycleState.DISCONNECTED) {
                    subscriber.onCompleted();
                    return;
                }
                PooledByteBufAllocator allocator = DcpChannel.this.env.poolBuffers() ? PooledByteBufAllocator.DEFAULT : UnpooledByteBufAllocator.DEFAULT;
                Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().option(ChannelOption.ALLOCATOR, (Object)allocator)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)((int)DcpChannel.this.env.socketConnectTimeout()))).remoteAddress((SocketAddress)DcpChannel.this.inetAddress).channel(ChannelUtils.channelForEventLoopGroup(DcpChannel.this.env.eventLoopGroup()))).handler((ChannelHandler)new DcpPipeline(DcpChannel.this.env, DcpChannel.this.controlHandler, DcpChannel.this.conductor.configProvider()))).group(DcpChannel.this.env.eventLoopGroup());
                DcpChannel.this.transitionState((Enum)LifecycleState.CONNECTING);
                DcpChannel.this.connectFuture = bootstrap.connect();
                DcpChannel.this.connectFuture.addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        if (future.isSuccess()) {
                            DcpChannel.this.channel = future.channel();
                            if (DcpChannel.this.isShutdown) {
                                LOGGER.info("Connected Node {}, but got instructed to disconnect in the meantime.", (Object)RedactableArgument.system((Object)DcpChannel.this.inetAddress));
                                DcpChannel.this.disconnect().subscribe(new CompletableSubscriber(){

                                    public void onCompleted() {
                                        subscriber.onCompleted();
                                    }

                                    public void onError(Throwable e) {
                                        LOGGER.warn("Got error during disconnect.", e);
                                    }

                                    public void onSubscribe(Subscription d) {
                                    }
                                });
                            } else {
                                DcpChannel.this.transitionState((Enum)LifecycleState.CONNECTED);
                                LOGGER.info("Connected to Node {}", (Object)RedactableArgument.system((Object)DcpChannel.this.inetAddress));
                                DcpChannel.this.channel.closeFuture().addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

                                    public void operationComplete(ChannelFuture future) throws Exception {
                                        LOGGER.debug("Got notified of channel close on Node {}", (Object)DcpChannel.this.inetAddress);
                                        if (DcpChannel.this.env.persistencePollingEnabled()) {
                                            for (short vbid = 0; vbid < DcpChannel.this.streamIsOpen.length(); vbid = (short)((short)(vbid + 1))) {
                                                if (!DcpChannel.this.streamIsOpen.get(vbid)) continue;
                                                DcpChannel.this.env.streamEventBuffer().clear(vbid);
                                            }
                                        }
                                        DcpChannel.this.transitionState((Enum)LifecycleState.DISCONNECTED);
                                        if (!DcpChannel.this.isShutdown) {
                                            DcpChannel.this.dispatchReconnect();
                                        }
                                        DcpChannel.this.channel = null;
                                    }
                                });
                                subscriber.onCompleted();
                            }
                        } else {
                            LOGGER.info("Connect attempt to {} failed.", (Object)RedactableArgument.system((Object)DcpChannel.this.inetAddress), (Object)future.cause());
                            DcpChannel.this.transitionState((Enum)LifecycleState.DISCONNECTED);
                            subscriber.onError(future.cause());
                        }
                    }
                });
            }
        });
    }

    private void dispatchReconnect() {
        if (this.isShutdown) {
            LOGGER.debug("Ignoring reconnect on {} because already shutdown.", (Object)this.inetAddress);
            return;
        }
        LOGGER.info("Node {} socket closed, initiating reconnect.", (Object)RedactableArgument.system((Object)this.inetAddress));
        long delayMillis = this.reconnectDelay.calculate().toMillis();
        if (delayMillis > 0L) {
            LOGGER.info("Delaying reconnection attempt by {}ms", (Object)delayMillis);
        }
        Completable.timer((long)delayMillis, (TimeUnit)TimeUnit.MILLISECONDS).andThen(this.connect().retryWhen((Func1)RetryBuilder.any().max(Integer.MAX_VALUE).delay(Delay.exponential((TimeUnit)TimeUnit.MILLISECONDS, (long)4096L, (long)32L)).doOnRetry(new Action4<Integer, Throwable, Long, TimeUnit>(){

            public void call(Integer integer, Throwable throwable, Long aLong, TimeUnit timeUnit) {
                LOGGER.debug("Rescheduling Node reconnect for DCP channel {}", (Object)DcpChannel.this.inetAddress);
            }
        }).build())).subscribe(new CompletableSubscriber(){

            public void onCompleted() {
                LOGGER.debug("Completed Node connect for DCP channel {}", (Object)DcpChannel.this.inetAddress);
                for (short vbid = 0; vbid < DcpChannel.this.streamIsOpen.length(); vbid = (short)(vbid + 1)) {
                    if (!DcpChannel.this.streamIsOpen.get(vbid)) continue;
                    DcpChannel.this.conductor.maybeMovePartition(vbid);
                }
            }

            public void onError(Throwable e) {
                LOGGER.warn("Got error during connect (maybe retried) for node {}", (Object)RedactableArgument.system((Object)DcpChannel.this.inetAddress), (Object)e);
            }

            public void onSubscribe(Subscription d) {
            }
        });
    }

    public boolean isShutdown() {
        return this.isShutdown;
    }

    public Completable disconnect() {
        return Completable.create((Completable.OnSubscribe)new Completable.OnSubscribe(){

            public void call(final CompletableSubscriber subscriber) {
                DcpChannel.this.isShutdown = true;
                if (DcpChannel.this.channel != null) {
                    DcpChannel.this.transitionState((Enum)LifecycleState.DISCONNECTING);
                    DcpChannel.this.channel.close().addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(){

                        public void operationComplete(ChannelFuture future) throws Exception {
                            DcpChannel.this.transitionState((Enum)LifecycleState.DISCONNECTED);
                            LOGGER.info("Disconnected from Node {}", (Object)RedactableArgument.system((Object)DcpChannel.this.address()));
                            if (future.isSuccess()) {
                                subscriber.onCompleted();
                            } else {
                                LOGGER.debug("Error during channel close.", future.cause());
                                subscriber.onError(future.cause());
                            }
                        }
                    });
                } else if (DcpChannel.this.connectFuture != null) {
                    DcpChannel.this.connectFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

                        public void operationComplete(ChannelFuture channelFuture) throws Exception {
                            if (channelFuture.isSuccess()) {
                                channelFuture.channel().closeFuture().addListener((GenericFutureListener)new ChannelFutureListener(){

                                    public void operationComplete(ChannelFuture closeFuture) throws Exception {
                                        if (closeFuture.isSuccess()) {
                                            subscriber.onCompleted();
                                        } else {
                                            subscriber.onError(closeFuture.cause());
                                        }
                                    }
                                });
                            } else {
                                subscriber.onCompleted();
                            }
                        }
                    });
                } else {
                    subscriber.onCompleted();
                }
            }
        });
    }

    public InetSocketAddress address() {
        return this.inetAddress;
    }

    public Completable openStream(final short vbid, final long vbuuid, final long startSeqno, final long endSeqno, final long origSnapshotStartSeqno, final long origSnapshotEndSeqno) {
        return Completable.create((Completable.OnSubscribe)new Completable.OnSubscribe(){

            public void call(final CompletableSubscriber subscriber) {
                long snapshotEndSeqno;
                long snapshotStartSeqno;
                if (DcpChannel.this.state() != LifecycleState.CONNECTED) {
                    subscriber.onError((Throwable)new NotConnectedException());
                    return;
                }
                if (origSnapshotStartSeqno == startSeqno + 1L) {
                    LOGGER.debug("Disregarding snapshot marker from the future.");
                    snapshotStartSeqno = startSeqno;
                    snapshotEndSeqno = startSeqno;
                } else {
                    snapshotEndSeqno = origSnapshotEndSeqno;
                    snapshotStartSeqno = origSnapshotStartSeqno;
                }
                LOGGER.debug("Opening Stream against {} with vbid: {}, vbuuid: {}, startSeqno: {}, endSeqno: {},  snapshotStartSeqno: {}, snapshotEndSeqno: {}", new Object[]{DcpChannel.this.inetAddress, vbid, vbuuid, startSeqno, endSeqno, snapshotStartSeqno, snapshotEndSeqno});
                ByteBuf buffer = Unpooled.buffer();
                DcpOpenStreamRequest.init(buffer, vbid);
                DcpOpenStreamRequest.vbuuid(buffer, vbuuid);
                DcpOpenStreamRequest.startSeqno(buffer, startSeqno);
                DcpOpenStreamRequest.endSeqno(buffer, endSeqno);
                DcpOpenStreamRequest.snapshotStartSeqno(buffer, snapshotStartSeqno);
                DcpOpenStreamRequest.snapshotEndSeqno(buffer, snapshotEndSeqno);
                DcpChannel.this.sendRequest(buffer).addListener((GenericFutureListener)new DcpResponseListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void operationComplete(Future<DcpResponse> future) throws Exception {
                        if (!future.isSuccess()) {
                            LOGGER.debug("Failed open Stream against {} with vbid: {}", (Object)DcpChannel.this.inetAddress, (Object)vbid);
                            DcpChannel.this.streamIsOpen.set(vbid, false);
                            subscriber.onError(future.cause());
                            return;
                        }
                        ByteBuf buf = ((DcpResponse)future.getNow()).buffer();
                        try {
                            ResponseStatus status = MessageUtil.getResponseStatus(buf);
                            if (status == ResponseStatus.KEY_EXISTS) {
                                LOGGER.debug("Stream already open against {} with vbid: {}", (Object)DcpChannel.this.inetAddress, (Object)vbid);
                                subscriber.onCompleted();
                                return;
                            }
                            if (!status.isSuccess()) {
                                LOGGER.debug("Failed open Stream against {} with vbid: {}", (Object)DcpChannel.this.inetAddress, (Object)vbid);
                                DcpChannel.this.streamIsOpen.set(vbid, false);
                            }
                            if (status.isSuccess()) {
                                LOGGER.debug("Opened Stream against {} with vbid: {}", (Object)DcpChannel.this.inetAddress, (Object)vbid);
                                DcpChannel.this.streamIsOpen.set(vbid, true);
                                subscriber.onCompleted();
                                ByteBuf flog = Unpooled.buffer();
                                DcpFailoverLogResponse.init(flog);
                                DcpFailoverLogResponse.vbucket(flog, DcpOpenStreamResponse.vbucket(buf));
                                ByteBuf content = MessageUtil.getContent(buf).copy().writeShort((int)vbid);
                                MessageUtil.setContent(content, flog);
                                content.release();
                                DcpChannel.this.env.controlEventHandler().onEvent(dummyFlowController, flog);
                            } else if (status == ResponseStatus.ROLLBACK_REQUIRED) {
                                subscriber.onError((Throwable)((Object)new RollbackException()));
                                ByteBuf rb = Unpooled.buffer();
                                RollbackMessage.init(rb, vbid, DcpOpenStreamResponse.rollbackSeqno(buf));
                                DcpChannel.this.env.controlEventHandler().onEvent(dummyFlowController, rb);
                            } else if (status == ResponseStatus.NOT_MY_VBUCKET) {
                                subscriber.onError((Throwable)((Object)new NotMyVbucketException()));
                            } else {
                                subscriber.onError((Throwable)new IllegalStateException("Unhandled Status: " + status));
                            }
                        }
                        finally {
                            buf.release();
                        }
                    }
                });
            }
        });
    }

    public Completable closeStream(final short vbid) {
        return Completable.create((Completable.OnSubscribe)new Completable.OnSubscribe(){

            public void call(final CompletableSubscriber subscriber) {
                if (DcpChannel.this.state() != LifecycleState.CONNECTED) {
                    subscriber.onError((Throwable)new NotConnectedException());
                    return;
                }
                LOGGER.debug("Closing Stream against {} with vbid: {}", (Object)DcpChannel.this.inetAddress, (Object)vbid);
                ByteBuf buffer = Unpooled.buffer();
                DcpCloseStreamRequest.init(buffer);
                DcpCloseStreamRequest.vbucket(buffer, vbid);
                DcpChannel.this.sendRequest(buffer).addListener((GenericFutureListener)new DcpResponseListener(){

                    public void operationComplete(Future<DcpResponse> future) throws Exception {
                        DcpChannel.this.streamIsOpen.set(vbid, false);
                        if (future.isSuccess()) {
                            ((DcpResponse)future.getNow()).buffer().release();
                            LOGGER.debug("Closed Stream against {} with vbid: {}", (Object)DcpChannel.this.inetAddress, (Object)vbid);
                            subscriber.onCompleted();
                        } else {
                            LOGGER.debug("Failed close Stream against {} with vbid: {}", (Object)DcpChannel.this.inetAddress, (Object)vbid);
                            subscriber.onError(future.cause());
                        }
                    }
                });
            }
        });
    }

    public Single<ByteBuf> getSeqnos() {
        return Single.create((Single.OnSubscribe)new Single.OnSubscribe<ByteBuf>(){

            public void call(final SingleSubscriber<? super ByteBuf> subscriber) {
                if (DcpChannel.this.state() != LifecycleState.CONNECTED) {
                    subscriber.onError((Throwable)new NotConnectedException());
                    return;
                }
                ByteBuf buffer = Unpooled.buffer();
                DcpGetPartitionSeqnosRequest.init(buffer);
                DcpGetPartitionSeqnosRequest.vbucketState(buffer, VbucketState.ACTIVE);
                DcpChannel.this.sendRequest(buffer).addListener((GenericFutureListener)new DcpResponseListener(){

                    public void operationComplete(Future<DcpResponse> future) throws Exception {
                        if (future.isSuccess()) {
                            ByteBuf buf = ((DcpResponse)future.getNow()).buffer();
                            try {
                                subscriber.onSuccess((Object)MessageUtil.getContent(buf).copy());
                            }
                            finally {
                                buf.release();
                            }
                        } else {
                            subscriber.onError(future.cause());
                        }
                    }
                });
            }
        });
    }

    public Single<ByteBuf> getFailoverLog(final short vbid) {
        return Single.create((Single.OnSubscribe)new Single.OnSubscribe<ByteBuf>(){

            public void call(final SingleSubscriber<? super ByteBuf> subscriber) {
                if (DcpChannel.this.state() != LifecycleState.CONNECTED) {
                    subscriber.onError((Throwable)new NotConnectedException());
                    return;
                }
                ByteBuf buffer = Unpooled.buffer();
                DcpFailoverLogRequest.init(buffer);
                DcpFailoverLogRequest.vbucket(buffer, vbid);
                LOGGER.debug("Asked for failover log on {} for vbid: {}", (Object)DcpChannel.this.inetAddress, (Object)vbid);
                DcpChannel.this.sendRequest(buffer).addListener((GenericFutureListener)new DcpResponseListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void operationComplete(Future<DcpResponse> future) throws Exception {
                        if (!future.isSuccess()) {
                            LOGGER.debug("Failed to ask for failover log on {} for vbid: {}", (Object)DcpChannel.this.inetAddress, (Object)vbid);
                            subscriber.onError(future.cause());
                            return;
                        }
                        ByteBuf buf = ((DcpResponse)future.getNow()).buffer();
                        try {
                            ByteBuf flog = Unpooled.buffer();
                            DcpFailoverLogResponse.init(flog);
                            DcpFailoverLogResponse.vbucket(flog, DcpFailoverLogResponse.vbucket(buf));
                            ByteBuf copiedBuf = MessageUtil.getContent(buf).copy().writeShort((int)vbid);
                            MessageUtil.setContent(copiedBuf, flog);
                            copiedBuf.release();
                            LOGGER.debug("Failover log for vbid {} is {}", (Object)vbid, (Object)DcpFailoverLogResponse.toString(flog));
                            subscriber.onSuccess((Object)flog);
                        }
                        finally {
                            buf.release();
                        }
                    }
                });
            }
        });
    }

    public boolean streamIsOpen(short vbid) {
        return this.streamIsOpen.get(vbid);
    }

    public boolean equals(Object o) {
        if (o instanceof InetAddress) {
            return this.inetAddress.equals(o);
        }
        if (o instanceof DcpChannel) {
            return this.inetAddress.equals(((DcpChannel)((Object)o)).inetAddress);
        }
        return false;
    }

    public int hashCode() {
        return this.inetAddress.hashCode();
    }

    public String toString() {
        return "DcpChannel{inetAddress=" + this.inetAddress + '}';
    }
}

