/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.config;

import com.couchbase.client.dcp.util.Version;
import java.util.Collections;
import java.util.Map;

public enum CompressionMode {
    DISABLED{

        @Override
        public CompressionMode effectiveMode(Version serverVersion) {
            return DISABLED;
        }

        @Override
        public Map<String, String> getDcpControls(Version serverVersion) {
            return Collections.emptyMap();
        }

        @Override
        public short[] getHelloFeatures(Version serverVersion) {
            return EMPTY_SHORT_ARRAY;
        }
    }
    ,
    FORCED{

        @Override
        public CompressionMode effectiveMode(Version serverVersion) {
            return serverVersion.isAtLeast(VULCAN) ? this : DISABLED;
        }

        @Override
        public Map<String, String> getDcpControls(Version serverVersion) {
            if (!serverVersion.isAtLeast(VULCAN)) {
                throw new IllegalArgumentException("Server version " + serverVersion + " does not support value compression");
            }
            return Collections.singletonMap("force_value_compression", String.valueOf(true));
        }
    }
    ,
    ENABLED{

        @Override
        public CompressionMode effectiveMode(Version serverVersion) {
            return serverVersion.isAtLeast(VULCAN) ? this : DISABLED;
        }

        @Override
        public Map<String, String> getDcpControls(Version serverVersion) {
            return Collections.emptyMap();
        }
    };

    private static final short[] EMPTY_SHORT_ARRAY;
    private static final Version VULCAN;

    public abstract CompressionMode effectiveMode(Version var1);

    public abstract Map<String, String> getDcpControls(Version var1);

    public short[] getHelloFeatures(Version serverVersion) {
        return new short[]{1, 10};
    }

    static {
        EMPTY_SHORT_ARRAY = new short[0];
        VULCAN = new Version(5, 5, 0);
    }
}

