/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.config;

import com.couchbase.client.core.logging.RedactableArgument;
import java.net.InetSocketAddress;
import java.util.Objects;

public class HostAndPort {
    private final String host;
    private final int port;

    public HostAndPort(String host, int port) {
        this.host = Objects.requireNonNull(host);
        this.port = port;
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public HostAndPort withPort(int port) {
        return this.port == port ? this : new HostAndPort(this.host, port);
    }

    public InetSocketAddress toAddress() {
        return new InetSocketAddress(this.host, this.port);
    }

    public String toString() {
        return "HostAndPort{host='" + RedactableArgument.system((Object)this.host) + '\'' + ", port=" + RedactableArgument.system((Object)this.port) + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HostAndPort that = (HostAndPort)o;
        return this.port == that.port && this.host.equals(that.host);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port);
    }
}

