/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.events;

import com.couchbase.client.core.event.CouchbaseEvent;
import com.couchbase.client.core.event.EventBus;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import rx.Observable;
import rx.Scheduler;
import rx.subjects.PublishSubject;
import rx.subjects.SerializedSubject;

public class DefaultDcpEventBus
implements EventBus {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(DefaultDcpEventBus.class);
    private final SerializedSubject<CouchbaseEvent, CouchbaseEvent> bus = PublishSubject.create().toSerialized();
    private final Scheduler scheduler;

    public DefaultDcpEventBus(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public Observable<CouchbaseEvent> get() {
        return this.bus.onBackpressureBuffer().observeOn(this.scheduler);
    }

    public void publish(CouchbaseEvent event) {
        if (this.bus.hasObservers()) {
            try {
                this.bus.onNext((Object)event);
            }
            catch (Exception ex) {
                LOGGER.warn("Caught exception during event emission, moving on.", (Throwable)ex);
            }
        }
    }

    public boolean hasSubscribers() {
        return this.bus.hasObservers();
    }
}

