/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.message;

import com.couchbase.client.dcp.message.MessageUtil;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.deps.io.netty.buffer.Unpooled;

public enum HelloRequest {

    public static final short DATATYPE = 1;
    public static final short TLS = 2;
    public static final short TCPNODELAY = 3;
    public static final short MUTATIONSEQ = 4;
    public static final short TCPDELAY = 5;
    public static final short XATTR = 6;
    public static final short XERROR = 7;
    public static final short SELECT = 8;
    public static final short SNAPPY = 10;
    private static final short[] standardFeatures = new short[]{7, 8};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(ByteBuf buffer, String connectionName, short ... extraFeatures) {
        MessageUtil.initRequest((byte)31, buffer);
        MessageUtil.setKey(connectionName, buffer);
        ByteBuf features = Unpooled.buffer((int)((standardFeatures.length + extraFeatures.length) * 2));
        try {
            for (short feature : standardFeatures) {
                features.writeShort((int)feature);
            }
            for (short feature : extraFeatures) {
                features.writeShort((int)feature);
            }
            MessageUtil.setContent(features, buffer);
        }
        finally {
            features.release();
        }
    }
}

