/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.message;

import com.couchbase.client.dcp.message.ResponseStatus;
import com.couchbase.client.dcp.util.PatchedNettySnappyDecoder;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.deps.io.netty.buffer.UnpooledByteBufAllocator;
import com.couchbase.client.deps.io.netty.util.CharsetUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public enum MessageUtil {

    public static final int HEADER_SIZE = 24;
    public static final byte MAGIC_INT = 121;
    public static final byte MAGIC_REQ = -128;
    public static final byte MAGIC_RES = -127;
    public static final short KEY_LENGTH_OFFSET = 2;
    public static final short EXTRAS_LENGTH_OFFSET = 4;
    public static final short DATA_TYPE_OFFSET = 5;
    public static final short VBUCKET_OFFSET = 6;
    public static final short BODY_LENGTH_OFFSET = 8;
    public static final short OPAQUE_OFFSET = 12;
    public static final short CAS_OFFSET = 16;
    public static final byte NOOP_OPCODE = 10;
    public static final byte VERSION_OPCODE = 11;
    public static final byte HELLO_OPCODE = 31;
    public static final byte SASL_LIST_MECHS_OPCODE = 32;
    public static final byte SASL_AUTH_OPCODE = 33;
    public static final byte SASL_STEP_OPCODE = 34;
    public static final byte GET_SEQNOS_OPCODE = 72;
    public static final byte OPEN_CONNECTION_OPCODE = 80;
    public static final byte DCP_ADD_STREAM_OPCODE = 81;
    public static final byte DCP_STREAM_CLOSE_OPCODE = 82;
    public static final byte DCP_STREAM_REQUEST_OPCODE = 83;
    public static final byte DCP_FAILOVER_LOG_OPCODE = 84;
    public static final byte DCP_STREAM_END_OPCODE = 85;
    public static final byte DCP_SNAPSHOT_MARKER_OPCODE = 86;
    public static final byte DCP_MUTATION_OPCODE = 87;
    public static final byte DCP_DELETION_OPCODE = 88;
    public static final byte DCP_EXPIRATION_OPCODE = 89;
    public static final byte DCP_FLUSH_OPCODE = 90;
    public static final byte DCP_SET_VBUCKET_STATE_OPCODE = 91;
    public static final byte DCP_NOOP_OPCODE = 92;
    public static final byte DCP_BUFFER_ACK_OPCODE = 93;
    public static final byte DCP_CONTROL_OPCODE = 94;
    public static final byte SELECT_BUCKET_OPCODE = -119;
    public static final byte OBSERVE_SEQNO_OPCODE = -111;
    public static final byte INTERNAL_ROLLBACK_OPCODE = 1;
    private static final String[] OPCODE_NAMES = MessageUtil.initOpcodeNames();
    private static final UnpooledByteBufAllocator decompressedContentAllocator = new UnpooledByteBufAllocator(false, true);

    private static String[] initOpcodeNames() {
        String[] names = new String[256];
        try {
            String suffix = "_OPCODE";
            for (Field f : MessageUtil.class.getDeclaredFields()) {
                String nameWithoutSuffix;
                if (f.getType() != Byte.TYPE || !Modifier.isPublic(f.getModifiers()) || !Modifier.isStatic(f.getModifiers()) || !f.getName().endsWith("_OPCODE")) continue;
                names[0xFF & f.getByte(null)] = nameWithoutSuffix = f.getName().substring(0, f.getName().length() - "_OPCODE".length());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return names;
    }

    public static boolean isComplete(ByteBuf buffer) {
        int readable = buffer.readableBytes();
        if (readable < 24) {
            return false;
        }
        return readable >= 24 + buffer.getInt(8);
    }

    public static String humanize(ByteBuf buffer) {
        int contentLength;
        StringBuilder sb = new StringBuilder();
        byte extrasLength = buffer.getByte(4);
        short keyLength = buffer.getShort(2);
        int bodyLength = buffer.getInt(8);
        sb.append("Field          (offset) (value)\n-----------------------------------\n");
        sb.append(String.format("Magic          (0)      %s\n", MessageUtil.formatMagic(buffer.getByte(0))));
        sb.append(String.format("Opcode         (1)      %s\n", MessageUtil.formatOpcode(buffer.getByte(1))));
        sb.append(String.format("Key Length     (2,3)    0x%04x\n", keyLength));
        sb.append(String.format("Extras Length  (4)      0x%02x\n", extrasLength));
        sb.append(String.format("Data Type      (5)      0x%02x\n", buffer.getByte(5)));
        if (buffer.getByte(0) == -128) {
            sb.append(String.format("VBucket        (6,7)    0x%04x\n", buffer.getShort(6)));
        } else {
            sb.append(String.format("Status         (6,7)    %s\n", MessageUtil.getResponseStatus(buffer)));
        }
        sb.append(String.format("Total Body     (8-11)   0x%08x\n", bodyLength));
        sb.append(String.format("Opaque         (12-15)  0x%08x\n", buffer.getInt(12)));
        sb.append(String.format("CAS            (16-23)  0x%016x\n", buffer.getLong(16)));
        if (extrasLength > 0) {
            sb.append("+ Extras with " + extrasLength + " bytes\n");
        }
        if (keyLength > 0) {
            sb.append("+ Key with " + keyLength + " bytes\n");
        }
        if ((contentLength = bodyLength - extrasLength - keyLength) > 0) {
            sb.append("+ Content with " + contentLength + " bytes\n");
        }
        return sb.toString();
    }

    public static void initRequest(byte opcode, ByteBuf buffer) {
        buffer.writeByte(-128);
        buffer.writeByte((int)opcode);
        buffer.writeZero(22);
    }

    public static void initResponse(byte opcode, ByteBuf buffer) {
        buffer.writeByte(-127);
        buffer.writeByte((int)opcode);
        buffer.writeZero(22);
    }

    public static void setExtras(ByteBuf extras, ByteBuf buffer) {
        byte oldExtrasLength = buffer.getByte(4);
        byte newExtrasLength = (byte)extras.readableBytes();
        int oldBodyLength = buffer.getInt(8);
        int newBodyLength = oldBodyLength - oldExtrasLength + newExtrasLength;
        buffer.setByte(4, (int)newExtrasLength);
        buffer.setInt(8, newBodyLength);
        buffer.setBytes(24, extras);
        buffer.writerIndex(24 + newBodyLength);
    }

    public static ByteBuf getExtras(ByteBuf buffer) {
        return buffer.slice(24, (int)buffer.getByte(4));
    }

    public static void setVbucket(short vbucket, ByteBuf buffer) {
        buffer.setShort(6, (int)vbucket);
    }

    public static short getVbucket(ByteBuf buffer) {
        return buffer.getShort(6);
    }

    public static void setKey(String key, ByteBuf buffer) {
        byte[] keyBytes = key.getBytes(CharsetUtil.UTF_8);
        short oldKeyLength = buffer.getShort(2);
        short newKeyLength = (short)keyBytes.length;
        int oldBodyLength = buffer.getInt(8);
        byte extrasLength = buffer.getByte(4);
        int newBodyLength = oldBodyLength - oldKeyLength + newKeyLength;
        buffer.setShort(2, (int)newKeyLength);
        buffer.setInt(8, newBodyLength);
        buffer.writerIndex(24 + extrasLength);
        buffer.writeBytes(keyBytes);
        buffer.writerIndex(24 + newBodyLength);
    }

    public static ByteBuf getKey(ByteBuf buffer) {
        byte extrasLength = buffer.getByte(4);
        short keyLength = buffer.getShort(2);
        return buffer.slice(24 + extrasLength, (int)keyLength);
    }

    public static String getKeyAsString(ByteBuf buffer) {
        byte extrasLength = buffer.getByte(4);
        short keyLength = buffer.getShort(2);
        return buffer.toString(24 + extrasLength, (int)keyLength, CharsetUtil.UTF_8);
    }

    public static void setContent(ByteBuf content, ByteBuf buffer) {
        short keyLength = buffer.getShort(2);
        byte extrasLength = buffer.getByte(4);
        int bodyLength = keyLength + extrasLength + content.readableBytes();
        int contentOffset = 24 + extrasLength + keyLength;
        buffer.setInt(8, bodyLength);
        buffer.writerIndex(contentOffset);
        buffer.ensureWritable(content.readableBytes());
        buffer.writeBytes(content);
        buffer.writerIndex(24 + bodyLength);
    }

    public static ByteBuf getRawContent(ByteBuf buffer) {
        short keyLength = buffer.getShort(2);
        byte extrasLength = buffer.getByte(4);
        int contentLength = buffer.getInt(8) - keyLength - extrasLength;
        return buffer.slice(24 + keyLength + extrasLength, contentLength);
    }

    public static ByteBuf getContent(ByteBuf buffer) {
        ByteBuf rawContent = MessageUtil.getRawContent(buffer);
        if (!MessageUtil.isSnappyCompressed(buffer)) {
            return rawContent;
        }
        int decompressedLength = PatchedNettySnappyDecoder.readPreamble(rawContent);
        rawContent.readerIndex(0);
        ByteBuf decompressedContent = decompressedContentAllocator.heapBuffer(decompressedLength, decompressedLength);
        new PatchedNettySnappyDecoder().decode(rawContent, decompressedContent);
        return decompressedContent;
    }

    public static boolean isSnappyCompressed(ByteBuf buffer) {
        int DATA_TYPE_SNAPPY = 2;
        byte dataType = buffer.getByte(5);
        return (dataType & 2) == 2;
    }

    public static String getContentAsString(ByteBuf buffer) {
        return MessageUtil.getContent(buffer).toString(CharsetUtil.UTF_8);
    }

    public static byte[] getContentAsByteArray(ByteBuf buffer) {
        ByteBuf content = MessageUtil.getContent(buffer);
        if (MessageUtil.isSnappyCompressed(buffer)) {
            if (!(content.alloc() instanceof UnpooledByteBufAllocator)) {
                throw new RuntimeException("Expected decompressed content buffer to be unpooled.");
            }
            if (content.array().length != content.readableBytes()) {
                throw new RuntimeException("Expected decompressed content buffer to be backed by array of exact size.");
            }
            return content.array();
        }
        byte[] bytes = new byte[content.readableBytes()];
        content.getBytes(0, bytes);
        return bytes;
    }

    @Deprecated
    public static short getStatus(ByteBuf buffer) {
        return buffer.getShort(6);
    }

    public static ResponseStatus getResponseStatus(ByteBuf buffer) {
        return ResponseStatus.valueOf(buffer.getShort(6));
    }

    public static byte getDataType(ByteBuf buffer) {
        return buffer.getByte(5);
    }

    public static void setDataType(byte dataType, ByteBuf buffer) {
        buffer.setByte(5, (int)dataType);
    }

    public static void setOpaque(int opaque, ByteBuf buffer) {
        buffer.setInt(12, opaque);
    }

    public static int getOpaque(ByteBuf buffer) {
        return buffer.getInt(12);
    }

    public static long getCas(ByteBuf buffer) {
        return buffer.getLong(16);
    }

    private static String formatOpcode(byte opcode) {
        return String.format("0x%02x (%s)", opcode, MessageUtil.getOpcodeName(opcode));
    }

    private static String getOpcodeName(byte opcode) {
        String unknownName = "?";
        try {
            String name = OPCODE_NAMES[0xFF & opcode];
            return name == null ? "?" : name;
        }
        catch (IndexOutOfBoundsException opcodeArrayNotSizedCorrectly) {
            return "?";
        }
    }

    private static String formatMagic(byte magic) {
        String name = magic == -128 ? "REQUEST" : (magic == -127 ? "RESPONSE" : "?");
        return String.format("0x%02x (%s)", magic, name);
    }
}

