/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.message;

public class ResponseStatus {
    private static final ResponseStatus[] values = new ResponseStatus[256];
    public static final ResponseStatus NO_ERROR = new ResponseStatus(0, "No error");
    public static final ResponseStatus KEY_NOT_FOUND = new ResponseStatus(1, "Key not found");
    public static final ResponseStatus KEY_EXISTS = new ResponseStatus(2, "Key exists");
    public static final ResponseStatus VALUE_TOO_LARGE = new ResponseStatus(3, "Value too large");
    public static final ResponseStatus INVALID_ARGUMENTS = new ResponseStatus(4, "Invalid arguments");
    public static final ResponseStatus ITEM_NOT_STORED = new ResponseStatus(5, "Item not stored");
    public static final ResponseStatus NON_NUMERIC = new ResponseStatus(6, "Incr/Decr on a non-numeric value");
    public static final ResponseStatus NOT_MY_VBUCKET = new ResponseStatus(7, "The vbucket belongs to another server");
    public static final ResponseStatus NOT_CONNECTED_TO_BUCKET = new ResponseStatus(8, "The connection is not connected to a bucket");
    public static final ResponseStatus STALE_AUTH_CONTEXT = new ResponseStatus(31, "The authentication context is stale, please re-authenticate");
    public static final ResponseStatus AUTH_ERROR = new ResponseStatus(32, "Authentication error");
    public static final ResponseStatus AUTH_CONTINUE = new ResponseStatus(33, "Authentication continue");
    public static final ResponseStatus ILLEGAL_RANGE = new ResponseStatus(34, "The requested value is outside the legal ranges");
    public static final ResponseStatus ROLLBACK_REQUIRED = new ResponseStatus(35, "Rollback required");
    public static final ResponseStatus NO_ACCESS = new ResponseStatus(36, "No access / insufficient permissions");
    public static final ResponseStatus INITIALIZING_NODE = new ResponseStatus(37, "The node is being initialized");
    public static final ResponseStatus UNKNOWN_COMMAND = new ResponseStatus(129, "Unknown command");
    public static final ResponseStatus OUT_OF_MEMORY = new ResponseStatus(130, "Out of memory");
    public static final ResponseStatus NOT_SUPPORTED = new ResponseStatus(131, "Not supported");
    public static final ResponseStatus INTERNAL_ERROR = new ResponseStatus(132, "Internal error");
    public static final ResponseStatus BUSY = new ResponseStatus(133, "Busy");
    public static final ResponseStatus TEMPORARY_FAILURE = new ResponseStatus(134, "Temporary Failure");
    private final int code;
    private final String formatted;

    public static ResponseStatus valueOf(int code) {
        ResponseStatus status;
        if ((code &= 0xFFFF) < 256 && (status = values[code]) != null) {
            return status;
        }
        return new ResponseStatus(code);
    }

    private ResponseStatus(int code, String message) {
        this.code = code;
        this.formatted = ResponseStatus.format(code, message);
        if (values[code] != null) {
            throw new IllegalStateException("already initialized status " + values[code]);
        }
        ResponseStatus.values[code] = this;
    }

    private ResponseStatus(int code) {
        this.code = code;
        this.formatted = ResponseStatus.format(code, "???");
    }

    private static String format(int code, String message) {
        return String.format("0x%04x (%s)", code, message);
    }

    public int code() {
        return this.code;
    }

    public boolean isTemporary() {
        return this == BUSY || this == TEMPORARY_FAILURE;
    }

    public boolean isSuccess() {
        return this == NO_ERROR;
    }

    public String toString() {
        return this.formatted;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResponseStatus that = (ResponseStatus)o;
        return this.code == that.code;
    }

    public int hashCode() {
        return this.code;
    }
}

