/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.message;

public enum StreamEndReason {
    OK(0),
    CLOSED(1),
    STATE_CHANGED(2),
    DISCONNECTED(3),
    TOO_SLOW(4);

    private final int value;

    private StreamEndReason(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    static StreamEndReason of(int value) {
        switch (value) {
            case 0: {
                return OK;
            }
            case 1: {
                return CLOSED;
            }
            case 2: {
                return STATE_CHANGED;
            }
            case 3: {
                return DISCONNECTED;
            }
            case 4: {
                return TOO_SLOW;
            }
        }
        throw new IllegalArgumentException("Unknown stream end reason: " + value);
    }
}

