/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.transport.netty;

import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.dcp.message.MessageUtil;
import com.couchbase.client.dcp.message.ResponseStatus;
import com.couchbase.client.dcp.transport.netty.DcpMessageHandler;
import com.couchbase.client.dcp.transport.netty.DcpResponse;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.deps.io.netty.buffer.Unpooled;
import com.couchbase.client.deps.io.netty.channel.ChannelHandlerContext;
import com.couchbase.client.deps.io.netty.handler.timeout.IdleStateEvent;
import com.couchbase.client.deps.io.netty.handler.timeout.IdleStateHandler;
import java.util.concurrent.TimeUnit;

public class ClientNoopHandler
extends IdleStateHandler {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(ClientNoopHandler.class);

    public ClientNoopHandler(long readerIdleTime, TimeUnit unit) {
        super(readerIdleTime, 0L, 0L, unit);
    }

    protected void channelIdle(ChannelHandlerContext ctx, IdleStateEvent evt) throws Exception {
        LOGGER.debug("Nothing read from channel {} for {} seconds; sending client-side NOOP request.", (Object)ctx.channel(), (Object)TimeUnit.MILLISECONDS.toSeconds(this.getReaderIdleTimeInMillis()));
        ((DcpMessageHandler)ctx.pipeline().get(DcpMessageHandler.class)).sendRequest(ClientNoopHandler.newNoopRequest()).addListener(future -> {
            if (future.isSuccess()) {
                ByteBuf response = ((DcpResponse)future.getNow()).buffer();
                try {
                    ResponseStatus status = MessageUtil.getResponseStatus(response);
                    if (status.isSuccess()) {
                        LOGGER.debug("Got successful response to client-side NOOP for channel {}", (Object)ctx.channel());
                    }
                    LOGGER.warn("Got error response to client-side NOOP for channel {}: {}", (Object)ctx.channel(), (Object)status);
                }
                finally {
                    response.release();
                }
            } else {
                LOGGER.warn("Failed to send client-side NOOP for channel {}", (Object)ctx.channel(), (Object)future.cause());
            }
        });
    }

    private static ByteBuf newNoopRequest() {
        ByteBuf buffer = Unpooled.buffer();
        MessageUtil.initRequest((byte)10, buffer);
        return buffer;
    }
}

