/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.transport.netty;

import com.couchbase.client.core.config.BucketConfig;
import com.couchbase.client.core.config.CouchbaseBucketConfig;
import com.couchbase.client.core.config.DefaultConfigurationProvider;
import com.couchbase.client.core.config.parser.BucketConfigParser;
import com.couchbase.client.core.env.ConfigParserEnvironment;
import com.couchbase.client.core.env.NetworkResolution;
import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.logging.RedactableArgument;
import com.couchbase.client.dcp.buffer.DcpBucketConfig;
import com.couchbase.client.dcp.config.ClientEnvironment;
import com.couchbase.client.dcp.config.HostAndPort;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.deps.io.netty.channel.ChannelHandlerContext;
import com.couchbase.client.deps.io.netty.channel.SimpleChannelInboundHandler;
import com.couchbase.client.deps.io.netty.handler.codec.http.HttpContent;
import com.couchbase.client.deps.io.netty.handler.codec.http.HttpObject;
import com.couchbase.client.deps.io.netty.util.CharsetUtil;
import java.net.InetSocketAddress;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import rx.subjects.Subject;

class ConfigHandler
extends SimpleChannelInboundHandler<HttpObject> {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(ConfigHandler.class);
    private final Subject<DcpBucketConfig, DcpBucketConfig> configStream;
    private final AtomicLong currentBucketConfigRev;
    private final ClientEnvironment environment;
    private ByteBuf responseContent;
    private boolean hasDeterminedAlternateNetworkName = false;
    private String alternateNetworkName;

    ConfigHandler(Subject<DcpBucketConfig, DcpBucketConfig> configStream, AtomicLong currentBucketConfigRev, ClientEnvironment environment) {
        this.configStream = Objects.requireNonNull(configStream);
        this.currentBucketConfigRev = Objects.requireNonNull(currentBucketConfigRev);
        this.environment = Objects.requireNonNull(environment);
    }

    protected void channelRead0(ChannelHandlerContext ctx, HttpObject msg) throws Exception {
        if (msg instanceof HttpContent) {
            HttpContent content = (HttpContent)msg;
            this.decodeChunk((InetSocketAddress)ctx.channel().remoteAddress(), content.content());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decodeChunk(InetSocketAddress address, ByteBuf chunk) {
        this.responseContent.writeBytes(chunk);
        String currentChunk = this.responseContent.toString(CharsetUtil.UTF_8);
        int separatorIndex = currentChunk.indexOf("\n\n\n\n");
        if (separatorIndex > 0) {
            String rawConfig = currentChunk.substring(0, separatorIndex).trim().replace("$HOST", address.getAddress().getHostAddress());
            String origin = address.getAddress().getHostAddress();
            CouchbaseBucketConfig config = (CouchbaseBucketConfig)BucketConfigParser.parse((String)rawConfig, (ConfigParserEnvironment)this.environment, (String)origin);
            AtomicLong atomicLong = this.currentBucketConfigRev;
            synchronized (atomicLong) {
                if (config.rev() > this.currentBucketConfigRev.get()) {
                    this.selectAlternateNetwork(config);
                    LOGGER.trace("Publishing bucket config: {}", (Object)RedactableArgument.system((Object)rawConfig));
                    this.currentBucketConfigRev.set(config.rev());
                    this.configStream.onNext((Object)new DcpBucketConfig(config, this.environment.sslEnabled()));
                } else {
                    LOGGER.trace("Ignoring config, since rev has not changed.");
                }
            }
            this.responseContent.clear();
            this.responseContent.writeBytes(currentChunk.substring(separatorIndex + 4).getBytes(CharsetUtil.UTF_8));
        }
    }

    private void selectAlternateNetwork(CouchbaseBucketConfig config) {
        if (!this.hasDeterminedAlternateNetworkName) {
            String displayName;
            Set seedHosts = this.environment.clusterAt().stream().map(HostAndPort::host).collect(Collectors.toSet());
            this.alternateNetworkName = DefaultConfigurationProvider.determineNetworkResolution((BucketConfig)config, (NetworkResolution)this.environment.networkResolution(), seedHosts);
            this.hasDeterminedAlternateNetworkName = true;
            String string = displayName = this.alternateNetworkName == null ? "<default>" : this.alternateNetworkName;
            if (NetworkResolution.AUTO.equals((Object)this.environment.networkResolution())) {
                displayName = "auto -> " + displayName;
            }
            LOGGER.info("Selected network: {}", (Object)displayName);
        }
        config.useAlternateNetwork(this.alternateNetworkName);
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.responseContent = ctx.alloc().buffer();
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        if (this.responseContent != null && this.responseContent.refCnt() > 0) {
            this.responseContent.release();
            this.responseContent = null;
        }
    }
}

