/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.transport.netty;

import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.dcp.Credentials;
import com.couchbase.client.dcp.CredentialsProvider;
import com.couchbase.client.dcp.buffer.DcpBucketConfig;
import com.couchbase.client.dcp.config.ClientEnvironment;
import com.couchbase.client.dcp.config.SSLEngineFactory;
import com.couchbase.client.dcp.transport.netty.ConfigHandler;
import com.couchbase.client.dcp.transport.netty.StartStreamHandler;
import com.couchbase.client.deps.io.netty.channel.Channel;
import com.couchbase.client.deps.io.netty.channel.ChannelHandler;
import com.couchbase.client.deps.io.netty.channel.ChannelInitializer;
import com.couchbase.client.deps.io.netty.channel.ChannelPipeline;
import com.couchbase.client.deps.io.netty.handler.codec.http.HttpClientCodec;
import com.couchbase.client.deps.io.netty.handler.logging.LogLevel;
import com.couchbase.client.deps.io.netty.handler.logging.LoggingHandler;
import com.couchbase.client.deps.io.netty.handler.ssl.SslHandler;
import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicLong;
import rx.subjects.Subject;

public class ConfigPipeline
extends ChannelInitializer<Channel> {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(ConfigPipeline.class);
    private final ClientEnvironment environment;
    private final InetSocketAddress address;
    private final String bucket;
    private final Subject<DcpBucketConfig, DcpBucketConfig> configStream;
    private final AtomicLong currentBucketConfigRev;
    private final SSLEngineFactory sslEngineFactory;

    public ConfigPipeline(ClientEnvironment environment, InetSocketAddress address, Subject<DcpBucketConfig, DcpBucketConfig> configStream, AtomicLong currentBucketConfigRev) {
        this.address = address;
        this.bucket = environment.bucket();
        this.configStream = configStream;
        this.currentBucketConfigRev = currentBucketConfigRev;
        this.environment = environment;
        this.sslEngineFactory = environment.sslEnabled() ? new SSLEngineFactory(environment) : null;
    }

    protected void initChannel(Channel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        if (this.environment.sslEnabled()) {
            pipeline.addLast(new ChannelHandler[]{new SslHandler(this.sslEngineFactory.get())});
        }
        if (LOGGER.isTraceEnabled()) {
            pipeline.addLast(new ChannelHandler[]{new LoggingHandler(LogLevel.TRACE)});
        }
        CredentialsProvider credentialsProvider = this.environment.credentialsProvider();
        Credentials credentials = credentialsProvider.get(this.address);
        pipeline.addLast(new ChannelHandler[]{new HttpClientCodec()}).addLast(new ChannelHandler[]{new StartStreamHandler(this.bucket, credentials.getUsername(), credentials.getPassword())}).addLast(new ChannelHandler[]{new ConfigHandler(this.configStream, this.currentBucketConfigRev, this.environment)});
    }
}

