/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.transport.netty;

import com.couchbase.client.dcp.message.MessageUtil;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.deps.io.netty.buffer.ByteBufHolder;
import com.couchbase.client.deps.io.netty.channel.ChannelHandler;
import com.couchbase.client.deps.io.netty.handler.logging.LogLevel;
import com.couchbase.client.deps.io.netty.handler.logging.LoggingHandler;

@ChannelHandler.Sharable
public class DcpLoggingHandler
extends LoggingHandler {
    public DcpLoggingHandler() {
    }

    public DcpLoggingHandler(LogLevel level) {
        super(level);
    }

    public DcpLoggingHandler(Class<?> clazz) {
        super(clazz);
    }

    public DcpLoggingHandler(Class<?> clazz, LogLevel level) {
        super(clazz, level);
    }

    public DcpLoggingHandler(String name) {
        super(name);
    }

    public DcpLoggingHandler(String name, LogLevel level) {
        super(name, level);
    }

    protected String formatMessage(String eventName, Object msg) {
        if (msg instanceof ByteBuf) {
            return this.formatByteBuf(eventName, (ByteBuf)msg);
        }
        if (msg instanceof ByteBufHolder) {
            return this.formatByteBufHolder(eventName, (ByteBufHolder)msg);
        }
        return this.formatNonByteBuf(eventName, msg);
    }

    protected String formatByteBuf(String eventName, ByteBuf msg) {
        int length = msg.readableBytes();
        if (length == 0) {
            StringBuilder buf = new StringBuilder(eventName.length() + 4);
            buf.append(eventName).append(": 0B");
            return buf.toString();
        }
        return "\n" + MessageUtil.humanize(msg);
    }

    protected String formatByteBufHolder(String eventName, ByteBufHolder msg) {
        return this.formatByteBuf(eventName, msg.content());
    }
}

