/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.transport.netty;

import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.core.state.NotConnectedException;
import com.couchbase.client.dcp.DataEventHandler;
import com.couchbase.client.dcp.buffer.DcpRequestDispatcher;
import com.couchbase.client.dcp.conductor.DcpChannelControlHandler;
import com.couchbase.client.dcp.config.ClientEnvironment;
import com.couchbase.client.dcp.message.DcpDeletionMessage;
import com.couchbase.client.dcp.message.DcpExpirationMessage;
import com.couchbase.client.dcp.message.DcpMutationMessage;
import com.couchbase.client.dcp.message.DcpNoopRequest;
import com.couchbase.client.dcp.message.DcpNoopResponse;
import com.couchbase.client.dcp.message.DcpSnapshotMarkerRequest;
import com.couchbase.client.dcp.message.DcpStreamEndMessage;
import com.couchbase.client.dcp.message.MessageUtil;
import com.couchbase.client.dcp.transport.netty.ChannelFlowController;
import com.couchbase.client.dcp.transport.netty.ChannelFlowControllerImpl;
import com.couchbase.client.dcp.transport.netty.DcpResponse;
import com.couchbase.client.deps.io.netty.buffer.ByteBuf;
import com.couchbase.client.deps.io.netty.channel.Channel;
import com.couchbase.client.deps.io.netty.channel.ChannelHandlerContext;
import com.couchbase.client.deps.io.netty.channel.ChannelInboundHandlerAdapter;
import com.couchbase.client.deps.io.netty.handler.timeout.IdleState;
import com.couchbase.client.deps.io.netty.handler.timeout.IdleStateEvent;
import com.couchbase.client.deps.io.netty.util.ReferenceCountUtil;
import com.couchbase.client.deps.io.netty.util.concurrent.EventExecutor;
import com.couchbase.client.deps.io.netty.util.concurrent.Future;
import com.couchbase.client.deps.io.netty.util.concurrent.ImmediateEventExecutor;
import com.couchbase.client.deps.io.netty.util.concurrent.Promise;
import java.util.ArrayDeque;
import java.util.Objects;
import java.util.Queue;

public class DcpMessageHandler
extends ChannelInboundHandlerAdapter
implements DcpRequestDispatcher {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(DcpMessageHandler.class);
    private final DataEventHandler dataEventHandler;
    private final DcpChannelControlHandler controlHandler;
    private final ChannelFlowController flowController;
    private int nextOpaque = Integer.MIN_VALUE;
    private volatile ChannelHandlerContext volatileContext;
    private final Queue<OutstandingRequest> outstandingRequests = new ArrayDeque<OutstandingRequest>();

    DcpMessageHandler(Channel channel, ClientEnvironment environment, DcpChannelControlHandler controlHandler) {
        this.dataEventHandler = environment.dataEventHandler();
        this.controlHandler = controlHandler;
        this.flowController = new ChannelFlowControllerImpl(channel, environment);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.volatileContext = ctx;
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.volatileContext = null;
        NotConnectedException connectionClosed = new NotConnectedException("Channel became inactive while awaiting response.");
        for (OutstandingRequest request : this.outstandingRequests) {
            try {
                request.promise.setFailure((Throwable)connectionClosed);
            }
            catch (Throwable t) {
                LOGGER.error("Failed to set promise failure", t);
            }
        }
        this.outstandingRequests.clear();
        super.channelInactive(ctx);
    }

    @Override
    public Future<DcpResponse> sendRequest(final ByteBuf request) {
        ChannelHandlerContext ctx = this.volatileContext;
        if (ctx == null) {
            ReferenceCountUtil.safeRelease((Object)request);
            return ImmediateEventExecutor.INSTANCE.newFailedFuture((Throwable)new NotConnectedException("Failed to issue request; channel is not active."));
        }
        EventExecutor executor = ctx.executor();
        final Promise promise = executor.newPromise();
        if (executor.inEventLoop()) {
            this.unsafeSendRequest(ctx, request, (Promise<DcpResponse>)promise);
            return promise;
        }
        try {
            executor.submit(new Runnable(){

                @Override
                public void run() {
                    ChannelHandlerContext ctx = DcpMessageHandler.this.volatileContext;
                    if (ctx == null) {
                        ReferenceCountUtil.safeRelease((Object)request);
                        promise.setFailure((Throwable)new NotConnectedException("Failed to issue request; channel is not active."));
                    } else {
                        DcpMessageHandler.this.unsafeSendRequest(ctx, request, (Promise<DcpResponse>)promise);
                    }
                }
            });
        }
        catch (Throwable t) {
            ReferenceCountUtil.safeRelease((Object)request);
            promise.setFailure(t);
        }
        return promise;
    }

    private void unsafeSendRequest(ChannelHandlerContext ctx, ByteBuf request, Promise<DcpResponse> promise) {
        if (!ctx.executor().inEventLoop()) {
            throw new IllegalStateException("Must not be called outside event loop");
        }
        try {
            int opaque = this.nextOpaque++;
            MessageUtil.setOpaque(opaque, request);
            ctx.writeAndFlush((Object)request, ctx.voidPromise());
            this.outstandingRequests.add(new OutstandingRequest(opaque, promise));
        }
        catch (Throwable t) {
            promise.setFailure(t);
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        ByteBuf message = (ByteBuf)msg;
        byte magic = message.getByte(0);
        if (magic != -127) {
            this.handleRequest(ctx, message);
            return;
        }
        OutstandingRequest request = this.outstandingRequests.poll();
        if (request == null || MessageUtil.getOpaque(message) != request.opaque) {
            LOGGER.error("Unexpected response with opaque {} (expected {}); closing connection", (Object)MessageUtil.getOpaque(message), request == null ? "none" : Integer.valueOf(request.opaque));
            ctx.close();
            return;
        }
        request.promise.setSuccess((Object)new DcpResponse(message));
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        IdleStateEvent e;
        if (evt instanceof IdleStateEvent && (e = (IdleStateEvent)evt).state() == IdleState.READER_IDLE) {
            LOGGER.warn("Closing dead connection.");
            ctx.close();
            return;
        }
        super.userEventTriggered(ctx, evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRequest(ChannelHandlerContext ctx, ByteBuf message) {
        if (DcpMessageHandler.isDataMessage(message)) {
            this.dataEventHandler.onEvent(this.flowController, message);
        } else if (DcpMessageHandler.isControlMessage(message)) {
            this.controlHandler.onEvent(this.flowController, message);
        } else {
            if (DcpNoopRequest.is(message)) {
                try {
                    ByteBuf buffer = ctx.alloc().buffer();
                    DcpNoopResponse.init(buffer);
                    MessageUtil.setOpaque(MessageUtil.getOpaque(message), buffer);
                    ctx.writeAndFlush((Object)buffer);
                }
                finally {
                    message.release();
                }
            }
            try {
                LOGGER.warn("Unknown DCP Message, ignoring. \n{}", (Object)MessageUtil.humanize(message));
            }
            finally {
                message.release();
            }
        }
    }

    private static boolean isControlMessage(ByteBuf msg) {
        return DcpStreamEndMessage.is(msg) || DcpSnapshotMarkerRequest.is(msg);
    }

    private static boolean isDataMessage(ByteBuf msg) {
        return DcpMutationMessage.is(msg) || DcpDeletionMessage.is(msg) || DcpExpirationMessage.is(msg);
    }

    private static class OutstandingRequest {
        private final int opaque;
        private final Promise<DcpResponse> promise;

        private OutstandingRequest(int opaque, Promise<DcpResponse> promise) {
            this.opaque = opaque;
            this.promise = Objects.requireNonNull(promise);
        }
    }
}

