/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.transport.netty;

import com.couchbase.client.core.logging.CouchbaseLogger;
import com.couchbase.client.core.logging.CouchbaseLoggerFactory;
import com.couchbase.client.dcp.Credentials;
import com.couchbase.client.dcp.buffer.PersistencePollingHandler;
import com.couchbase.client.dcp.conductor.ConfigProvider;
import com.couchbase.client.dcp.conductor.DcpChannelControlHandler;
import com.couchbase.client.dcp.config.ClientEnvironment;
import com.couchbase.client.dcp.config.DcpControl;
import com.couchbase.client.dcp.config.SSLEngineFactory;
import com.couchbase.client.dcp.transport.netty.AuthHandler;
import com.couchbase.client.dcp.transport.netty.ClientNoopHandler;
import com.couchbase.client.dcp.transport.netty.DcpConnectHandler;
import com.couchbase.client.dcp.transport.netty.DcpControlHandler;
import com.couchbase.client.dcp.transport.netty.DcpLoggingHandler;
import com.couchbase.client.dcp.transport.netty.DcpMessageHandler;
import com.couchbase.client.dcp.transport.netty.HandshakeTimeoutHandler;
import com.couchbase.client.deps.io.netty.channel.Channel;
import com.couchbase.client.deps.io.netty.channel.ChannelHandler;
import com.couchbase.client.deps.io.netty.channel.ChannelInitializer;
import com.couchbase.client.deps.io.netty.channel.ChannelPipeline;
import com.couchbase.client.deps.io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import com.couchbase.client.deps.io.netty.handler.logging.LogLevel;
import com.couchbase.client.deps.io.netty.handler.logging.LoggingHandler;
import com.couchbase.client.deps.io.netty.handler.ssl.SslHandler;
import com.couchbase.client.deps.io.netty.handler.timeout.IdleStateHandler;
import java.net.InetSocketAddress;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class DcpPipeline
extends ChannelInitializer<Channel> {
    private static final CouchbaseLogger LOGGER = CouchbaseLoggerFactory.getInstance(DcpPipeline.class);
    private final ClientEnvironment environment;
    private final DcpChannelControlHandler controlHandler;
    private final SSLEngineFactory sslEngineFactory;
    private final ConfigProvider configProvider;

    public DcpPipeline(ClientEnvironment environment, DcpChannelControlHandler controlHandler, ConfigProvider configProvider) {
        this.configProvider = Objects.requireNonNull(configProvider);
        this.environment = Objects.requireNonNull(environment);
        this.controlHandler = Objects.requireNonNull(controlHandler);
        this.sslEngineFactory = environment.sslEnabled() ? new SSLEngineFactory(environment) : null;
    }

    protected void initChannel(Channel ch) throws Exception {
        ChannelPipeline pipeline = ch.pipeline();
        int gracePeriodMillis = Integer.parseInt(System.getProperty("com.couchbase.connectCallbackGracePeriod", "2000"));
        if (gracePeriodMillis != 0) {
            long handshakeTimeoutMillis = this.environment.socketConnectTimeout() + (long)gracePeriodMillis;
            pipeline.addLast(new ChannelHandler[]{new HandshakeTimeoutHandler(handshakeTimeoutMillis, TimeUnit.MILLISECONDS)});
        }
        if (this.environment.sslEnabled()) {
            pipeline.addLast(new ChannelHandler[]{new SslHandler(this.sslEngineFactory.get())});
        }
        pipeline.addLast(new ChannelHandler[]{new LengthFieldBasedFrameDecoder(Integer.MAX_VALUE, 8, 4, 12, 0, false)});
        if (LOGGER.isTraceEnabled()) {
            pipeline.addLast(new ChannelHandler[]{new LoggingHandler(LogLevel.TRACE)});
        }
        DcpControl control = this.environment.dcpControl();
        Credentials credentials = this.environment.credentialsProvider().get((InetSocketAddress)ch.remoteAddress());
        pipeline.addLast(new ChannelHandler[]{new AuthHandler(credentials.getUsername(), credentials.getPassword())}).addLast(new ChannelHandler[]{new DcpConnectHandler(this.environment.connectionNameGenerator(), this.environment.bucket(), control)}).addLast(new ChannelHandler[]{new DcpControlHandler(control)});
        if (control.noopEnabled()) {
            pipeline.addLast(new ChannelHandler[]{new IdleStateHandler(2 * control.noopIntervalSeconds(), 0, 0)});
            long serverNoopIntervalMillis = TimeUnit.SECONDS.toMillis(control.noopIntervalSeconds());
            long clientNoopIntervalMillis = (long)((double)serverNoopIntervalMillis * 1.2);
            pipeline.addLast(new ChannelHandler[]{new ClientNoopHandler(clientNoopIntervalMillis, TimeUnit.MILLISECONDS)});
        }
        if (LOGGER.isTraceEnabled()) {
            pipeline.addLast(new ChannelHandler[]{new DcpLoggingHandler(LogLevel.TRACE)});
        }
        DcpMessageHandler messageHandler = new DcpMessageHandler(ch, this.environment, this.controlHandler);
        pipeline.addLast(new ChannelHandler[]{messageHandler});
        if (this.environment.persistencePollingEnabled()) {
            pipeline.addLast(new ChannelHandler[]{new PersistencePollingHandler(this.environment, this.configProvider, messageHandler)});
        }
    }
}

