/*
 * Decompiled with CFR 0.152.
 */
package com.couchbase.client.dcp.util;

import com.couchbase.client.core.time.Delay;
import java.time.Duration;
import java.util.Objects;

public class AdaptiveDelay {
    private final Delay delay;
    private final long cooldownNanos;
    private long attempt;
    private long lastEventNanos;
    private final TimeProvider clock;

    public AdaptiveDelay(Delay backoffStrategy, Duration cooldown) {
        this(backoffStrategy, cooldown, System::nanoTime);
    }

    AdaptiveDelay(Delay delay, Duration cooldown, TimeProvider clock) {
        this.delay = Objects.requireNonNull(delay);
        this.clock = Objects.requireNonNull(clock);
        this.cooldownNanos = cooldown.toNanos();
        this.lastEventNanos = clock.nanoTime() - this.cooldownNanos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Duration calculate() {
        long now = this.clock.nanoTime();
        AdaptiveDelay adaptiveDelay = this;
        synchronized (adaptiveDelay) {
            boolean cooldownElapsed;
            long nanosSinceLastEvent = now - this.lastEventNanos;
            boolean bl = cooldownElapsed = nanosSinceLastEvent >= this.cooldownNanos;
            if (cooldownElapsed) {
                this.attempt = 0L;
                this.lastEventNanos = now;
                return Duration.ZERO;
            }
            long delayNanos = this.delay.unit().toNanos(this.delay.calculate(++this.attempt));
            this.lastEventNanos = now + delayNanos;
            return Duration.ofNanos(delayNanos);
        }
    }

    static interface TimeProvider {
        public long nanoTime();
    }
}

