/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly;

import com.sun.grizzly.Role;
import com.sun.grizzly.TCPSelectorHandler;
import com.sun.grizzly.util.Copyable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class ReusableTCPSelectorHandler
extends TCPSelectorHandler {
    private final ConcurrentHashMap<SocketAddress, SocketChannel> acceptedSocketChannelMap = new ConcurrentHashMap();
    private final CopyOnWriteArrayList<SocketChannel> reusableSocketChannels = new CopyOnWriteArrayList();

    public ReusableTCPSelectorHandler() {
        super(Role.CLIENT_SERVER);
    }

    public void copyTo(Copyable copy) {
        super.copyTo(copy);
        if (!(copy instanceof ReusableTCPSelectorHandler)) {
            return;
        }
        ReusableTCPSelectorHandler copyHandler = (ReusableTCPSelectorHandler)copy;
        copyHandler.acceptedSocketChannelMap.putAll(this.acceptedSocketChannelMap);
        copyHandler.reusableSocketChannels.addAll(this.reusableSocketChannels);
    }

    protected SelectableChannel getSelectableChannel(SocketAddress remoteAddress, SocketAddress localAddress) throws IOException {
        SelectableChannel selectableChannel = null;
        if (localAddress != null) {
            InetSocketAddress inetSocketAddress;
            if (this.inet != null && localAddress instanceof InetSocketAddress && this.inet.equals((inetSocketAddress = (InetSocketAddress)localAddress).getAddress())) {
                selectableChannel = this.getUsedSelectableChannel(remoteAddress);
            }
        } else {
            selectableChannel = this.getUsedSelectableChannel(remoteAddress);
        }
        if (selectableChannel == null) {
            selectableChannel = super.getSelectableChannel(remoteAddress, localAddress);
        }
        return selectableChannel;
    }

    private SelectableChannel getUsedSelectableChannel(SocketAddress remoteAddress) {
        if (remoteAddress != null) {
            SocketChannel acceptedSocketChannel = this.acceptedSocketChannelMap.get(remoteAddress);
            if (acceptedSocketChannel != null) {
                this.reusableSocketChannels.add(acceptedSocketChannel);
            }
            return acceptedSocketChannel;
        }
        return null;
    }

    public void shutdown() {
        super.shutdown();
        this.acceptedSocketChannelMap.clear();
        this.reusableSocketChannels.clear();
    }

    public SelectableChannel acceptWithoutRegistration(SelectionKey key) throws IOException {
        SocketChannel acceptedSocketChannel = ((ServerSocketChannel)key.channel()).accept();
        if (acceptedSocketChannel != null) {
            SocketAddress remoteSocketAddress = null;
            Socket acceptedSocket = acceptedSocketChannel.socket();
            if (acceptedSocket != null) {
                remoteSocketAddress = acceptedSocket.getRemoteSocketAddress();
            }
            if (remoteSocketAddress != null) {
                this.acceptedSocketChannelMap.put(remoteSocketAddress, acceptedSocketChannel);
            }
        }
        return acceptedSocketChannel;
    }

    public void closeChannel(SelectableChannel channel) {
        if (channel instanceof SocketChannel) {
            SocketChannel socketChannel = (SocketChannel)channel;
            if (this.reusableSocketChannels.remove(socketChannel)) {
                return;
            }
            Socket socket = socketChannel.socket();
            SocketAddress remoteSocketAddress = null;
            if (socket != null) {
                remoteSocketAddress = socket.getRemoteSocketAddress();
            }
            if (remoteSocketAddress != null) {
                this.acceptedSocketChannelMap.remove(remoteSocketAddress);
            }
        }
        super.closeChannel(channel);
    }
}

