/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grizzly.util;

import com.sun.grizzly.util.AttributeHolder;
import com.sun.grizzly.util.SelectionKeyActionAttachment;
import com.sun.grizzly.util.WorkerThread;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLEngine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadAttachment
extends SelectionKeyActionAttachment
implements AttributeHolder {
    private long transactionTimeout = Long.MIN_VALUE;
    private final ReentrantLock threadLock = new ReentrantLock();
    private String threadName;
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private ByteBuffer byteBuffer;
    private ByteBuffer inputBB;
    private ByteBuffer outputBB;
    private SSLEngine sslEngine;
    private int mode;
    private Thread activeThread = null;

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    @Override
    public void setAttribute(String key, Object value) {
        this.attributes.put(key, value);
    }

    @Override
    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    @Override
    public Object removeAttribute(String key) {
        return this.attributes.remove(key);
    }

    @Override
    public void setAttributes(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public void setByteBuffer(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
    }

    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    public ByteBuffer getInputBB() {
        return this.inputBB;
    }

    public void setInputBB(ByteBuffer inputBB) {
        this.inputBB = inputBB;
    }

    public ByteBuffer getOutputBB() {
        return this.outputBB;
    }

    public void setOutputBB(ByteBuffer outputBB) {
        this.outputBB = outputBB;
    }

    public SSLEngine getSSLEngine() {
        return this.sslEngine;
    }

    public void setSSLEngine(SSLEngine sslEngine) {
        this.sslEngine = sslEngine;
    }

    public String getThreadId() {
        return this.threadName;
    }

    public void setThreadId(String threadName) {
        this.threadName = threadName;
    }

    public void associate() {
        if (!this.threadLock.isHeldByCurrentThread()) {
            this.threadLock.lock();
            this.activeThread = Thread.currentThread();
        }
    }

    public void deassociate() {
        if (this.threadLock.isHeldByCurrentThread()) {
            this.activeThread = null;
            this.threadLock.unlock();
        }
    }

    @Override
    public void process(SelectionKey selectionKey) {
        ((WorkerThread)Thread.currentThread()).attach(this);
    }

    @Override
    public void postProcess(SelectionKey selectionKey) {
        ((WorkerThread)Thread.currentThread()).detach();
    }

    public void reset() {
        this.mode = 0;
        this.byteBuffer = null;
        this.sslEngine = null;
        this.inputBB = null;
        this.outputBB = null;
        this.transactionTimeout = Long.MIN_VALUE;
    }

    @Override
    public void release(SelectionKey selectionKey) {
        this.attributes.clear();
        this.reset();
        this.deassociate();
        super.release(selectionKey);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(256);
        sb.append("ThreadAttachment[mode=").append(this.mode);
        sb.append(", threadName=").append(this.threadName);
        sb.append(", byteBuffer=").append(this.byteBuffer);
        sb.append(", timeout=").append(this.getTimeout());
        sb.append(", sslEngine=").append(this.sslEngine);
        sb.append(", inputBB=").append(this.inputBB);
        sb.append(", outputBB=").append(this.outputBB);
        sb.append(", attributes=");
        if (this.threadLock.tryLock()) {
            sb.append(this.attributes);
            this.threadLock.unlock();
        } else {
            sb.append("inaccessible");
        }
        sb.append(']');
        return sb.toString();
    }

    public Thread activeThread() {
        return this.activeThread;
    }

    public long getTransactionTimeout() {
        return this.transactionTimeout;
    }

    public void setTransactionTimeout(long transactionTimeout) {
        this.transactionTimeout = transactionTimeout;
    }

    @Override
    public void setIdleTimeoutDelay(long idleTimeoutDelay) {
        super.setIdleTimeoutDelay(idleTimeoutDelay);
    }

    @Override
    public long getIdleTimeoutDelay() {
        if (ThreadAttachment.isUnlimitedTimeout(this.idleTimeoutDelay)) {
            return this.transactionTimeout;
        }
        if (this.transactionTimeout >= 0L && this.idleTimeoutDelay >= 0L) {
            return Math.min(this.transactionTimeout, this.idleTimeoutDelay);
        }
        if (this.idleTimeoutDelay >= 0L) {
            return this.idleTimeoutDelay;
        }
        return this.transactionTimeout;
    }

    protected static final boolean isUnlimitedTimeout(long timeout) {
        return timeout == Long.MIN_VALUE;
    }

    public static class Mode {
        public static final int ATTRIBUTES_ONLY = 0;
        public static final int BYTE_BUFFER = 2;
        public static final int INPUT_BB = 4;
        public static final int OUTPUT_BB = 8;
        public static final int SECURE_BUFFERS = 12;
        public static final int SSL_ENGINE = 16;
        public static final int SSL_ARTIFACTS = 28;
        public static final int STORE_ALL = 31;
    }
}

