/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.rss;

import com.sun.syndication.feed.synd.SyndFeed;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.camel.Exchange;
import org.apache.camel.dataformat.rss.RssConverter;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.util.ExchangeHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RssDataFormat
implements DataFormat {
    protected static final transient Logger LOG = LoggerFactory.getLogger(RssDataFormat.class);

    public void marshal(Exchange exchange, Object body, OutputStream out) throws Exception {
        SyndFeed feed = (SyndFeed)ExchangeHelper.convertToMandatoryType((Exchange)exchange, SyndFeed.class, (Object)body);
        String xml = RssConverter.feedToXml(feed);
        if (xml != null) {
            out.write(xml.getBytes());
        } else {
            LOG.debug("Cannot marshal RSS feed to XML.");
        }
    }

    public Object unmarshal(Exchange exchange, InputStream in) throws Exception {
        String xml = (String)ExchangeHelper.convertToMandatoryType((Exchange)exchange, String.class, (Object)in);
        return RssConverter.xmlToFeed(xml);
    }
}

