/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.Timer;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kafka.common.LogCleaningAbortedException;
import kafka.common.ThreadShutdownException;
import kafka.log.Cleaner;
import kafka.log.CleanerConfig;
import kafka.log.CleanerStats;
import kafka.log.CleanerStats$;
import kafka.log.Log;
import kafka.log.LogCleaner$;
import kafka.log.LogCleanerManager;
import kafka.log.LogToClean;
import kafka.log.SkimpyOffsetMap;
import kafka.metrics.KafkaMetricsGroup;
import kafka.metrics.KafkaMetricsGroup$class;
import kafka.server.LogDirFailureChannel;
import kafka.utils.Log4jController$;
import kafka.utils.Logging$class;
import kafka.utils.Pool;
import kafka.utils.ShutdownableThread;
import kafka.utils.Throttler;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.KafkaStorageException;
import org.apache.kafka.common.utils.Time;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\t\u0015d\u0001B\u0001\u0003\u0001\u001d\u0011!\u0002T8h\u00072,\u0017M\\3s\u0015\t\u0019A!A\u0002m_\u001eT\u0011!B\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001\u0001B\u0004\u000b\u0011\u0005%aQ\"\u0001\u0006\u000b\u0003-\tQa]2bY\u0006L!!\u0004\u0006\u0003\r\u0005s\u0017PU3g!\ty!#D\u0001\u0011\u0015\t\tB!A\u0003vi&d7/\u0003\u0002\u0014!\t9Aj\\4hS:<\u0007CA\u000b\u0019\u001b\u00051\"BA\f\u0005\u0003\u001diW\r\u001e:jGNL!!\u0007\f\u0003#-\u000bgm[1NKR\u0014\u0018nY:He>,\b\u000f\u0003\u0005\u001c\u0001\t\u0015\r\u0011\"\u0001\u001d\u0003\u0019\u0019wN\u001c4jOV\tQ\u0004\u0005\u0002\u001f?5\t!!\u0003\u0002!\u0005\ti1\t\\3b]\u0016\u00148i\u001c8gS\u001eD\u0001B\t\u0001\u0003\u0002\u0003\u0006I!H\u0001\bG>tg-[4!\u0011!!\u0003A!b\u0001\n\u0003)\u0013a\u00027pO\u0012K'o]\u000b\u0002MA\u0019qe\f\u001a\u000f\u0005!jcBA\u0015-\u001b\u0005Q#BA\u0016\u0007\u0003\u0019a$o\\8u}%\t1\"\u0003\u0002/\u0015\u00059\u0001/Y2lC\u001e,\u0017B\u0001\u00192\u0005\r\u0019V-\u001d\u0006\u0003])\u0001\"a\r\u001d\u000e\u0003QR!!\u000e\u001c\u0002\u0005%|'\"A\u001c\u0002\t)\fg/Y\u0005\u0003sQ\u0012AAR5mK\"A1\b\u0001B\u0001B\u0003%a%\u0001\u0005m_\u001e$\u0015N]:!\u0011!i\u0004A!b\u0001\n\u0003q\u0014\u0001\u00027pON,\u0012a\u0010\t\u0005\u001f\u0001\u0013U*\u0003\u0002B!\t!\u0001k\\8m!\t\u00195*D\u0001E\u0015\t)e)\u0001\u0004d_6lwN\u001c\u0006\u0003\u000b\u001dS!\u0001S%\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Q\u0015aA8sO&\u0011A\n\u0012\u0002\u000f)>\u0004\u0018n\u0019)beRLG/[8o!\tqb*\u0003\u0002P\u0005\t\u0019Aj\\4\t\u0011E\u0003!\u0011!Q\u0001\n}\nQ\u0001\\8hg\u0002B\u0001b\u0015\u0001\u0003\u0006\u0004%\t\u0001V\u0001\u0015Y><G)\u001b:GC&dWO]3DQ\u0006tg.\u001a7\u0016\u0003U\u0003\"AV-\u000e\u0003]S!\u0001\u0017\u0003\u0002\rM,'O^3s\u0013\tQvK\u0001\u000bM_\u001e$\u0015N\u001d$bS2,(/Z\"iC:tW\r\u001c\u0005\t9\u0002\u0011\t\u0011)A\u0005+\u0006)Bn\\4ESJ4\u0015-\u001b7ve\u0016\u001c\u0005.\u00198oK2\u0004\u0003\u0002\u00030\u0001\u0005\u0003\u0005\u000b\u0011B0\u0002\tQLW.\u001a\t\u0003A\nl\u0011!\u0019\u0006\u0003#\u0011K!aY1\u0003\tQKW.\u001a\u0005\u0006K\u0002!\tAZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\r\u001dD\u0017N[6m!\tq\u0002\u0001C\u0003\u001cI\u0002\u0007Q\u0004C\u0003%I\u0002\u0007a\u0005C\u0003>I\u0002\u0007q\bC\u0003TI\u0002\u0007Q\u000bC\u0004_IB\u0005\t\u0019A0\t\u00119\u0004!\u0019!C\u0001\u0005=\fab\u00197fC:,'/T1oC\u001e,'/F\u0001q!\tq\u0012/\u0003\u0002s\u0005\t\tBj\\4DY\u0016\fg.\u001a:NC:\fw-\u001a:\t\rQ\u0004\u0001\u0015!\u0003q\u0003=\u0019G.Z1oKJl\u0015M\\1hKJ\u0004\u0003b\u0002<\u0001\u0005\u0004%Ia^\u0001\ni\"\u0014x\u000e\u001e;mKJ,\u0012\u0001\u001f\t\u0003\u001feL!A\u001f\t\u0003\u0013QC'o\u001c;uY\u0016\u0014\bB\u0002?\u0001A\u0003%\u00010\u0001\u0006uQJ|G\u000f\u001e7fe\u0002BqA \u0001C\u0002\u0013%q0\u0001\u0005dY\u0016\fg.\u001a:t+\t\t\t\u0001\u0005\u0004\u0002\u0004\u00055\u0011\u0011C\u0007\u0003\u0003\u000bQA!a\u0002\u0002\n\u0005I\u0011.\\7vi\u0006\u0014G.\u001a\u0006\u0004\u0003\u0017Q\u0011AC2pY2,7\r^5p]&!\u0011qBA\u0003\u0005)Ie\u000eZ3yK\u0012\u001cV-\u001d\t\u0005\u0003'\t)\"D\u0001\u0001\r\u0019\t9\u0002\u0001\u0003\u0002\u001a\ti1\t\\3b]\u0016\u0014H\u000b\u001b:fC\u0012\u001cB!!\u0006\u0002\u001cA\u0019q\"!\b\n\u0007\u0005}\u0001C\u0001\nTQV$Hm\\<oC\ndW\r\u00165sK\u0006$\u0007bCA\u0012\u0003+\u0011\t\u0011)A\u0005\u0003K\t\u0001\u0002\u001e5sK\u0006$\u0017\n\u001a\t\u0004\u0013\u0005\u001d\u0012bAA\u0015\u0015\t\u0019\u0011J\u001c;\t\u000f\u0015\f)\u0002\"\u0001\u0002.Q!\u0011\u0011CA\u0018\u0011!\t\u0019#a\u000bA\u0002\u0005\u0015\u0002BCA\u001a\u0003+\u0011\r\u0011\"\u0011\u00026\u0005QAn\\4hKJt\u0015-\\3\u0016\u0005\u0005]\u0002\u0003BA\u001d\u0003\u007fi!!a\u000f\u000b\u0007\u0005ub'\u0001\u0003mC:<\u0017\u0002BA!\u0003w\u0011aa\u0015;sS:<\u0007\"CA#\u0003+\u0001\u000b\u0011BA\u001c\u0003-awnZ4fe:\u000bW.\u001a\u0011\t\u0015\u0005%\u0013Q\u0003b\u0001\n\u0003\tY%A\u0004dY\u0016\fg.\u001a:\u0016\u0005\u00055\u0003c\u0001\u0010\u0002P%\u0019\u0011\u0011\u000b\u0002\u0003\u000f\rcW-\u00198fe\"I\u0011QKA\u000bA\u0003%\u0011QJ\u0001\tG2,\u0017M\\3sA!Q\u0011\u0011LA\u000b\u0001\u0004%\t!a\u0017\u0002\u00131\f7\u000f^*uCR\u001cXCAA/!\rq\u0012qL\u0005\u0004\u0003C\u0012!\u0001D\"mK\u0006tWM]*uCR\u001c\bBCA3\u0003+\u0001\r\u0011\"\u0001\u0002h\u0005iA.Y:u'R\fGo]0%KF$B!!\u001b\u0002pA\u0019\u0011\"a\u001b\n\u0007\u00055$B\u0001\u0003V]&$\bBCA9\u0003G\n\t\u00111\u0001\u0002^\u0005\u0019\u0001\u0010J\u0019\t\u0013\u0005U\u0014Q\u0003Q!\n\u0005u\u0013A\u00037bgR\u001cF/\u0019;tA!\"\u00111OA=!\rI\u00111P\u0005\u0004\u0003{R!\u0001\u0003<pY\u0006$\u0018\u000e\\3\t\u0015\u0005\u0005\u0015Q\u0003b\u0001\n\u0013\t\u0019)\u0001\tcC\u000e\\wJ\u001a4XC&$H*\u0019;dQV\u0011\u0011Q\u0011\t\u0005\u0003\u000f\u000b\t*\u0004\u0002\u0002\n*!\u00111RAG\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0004\u0003\u001f3\u0014\u0001B;uS2LA!a%\u0002\n\nq1i\\;oi\u0012{wO\u001c'bi\u000eD\u0007\"CAL\u0003+\u0001\u000b\u0011BAC\u0003E\u0011\u0017mY6PM\u001a<\u0016-\u001b;MCR\u001c\u0007\u000e\t\u0005\t\u00037\u000b)\u0002\"\u0003\u0002\u001e\u0006I1\r[3dW\u0012{g.\u001a\u000b\u0005\u0003S\ny\nC\u0004\u0002\"\u0006e\u0005\u0019\u0001\"\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]\"A\u0011QUA\u000b\t\u0003\n9+\u0001\u0004e_^{'o\u001b\u000b\u0003\u0003SB\u0001\"a+\u0002\u0016\u0011\u0005\u0013qU\u0001\tg\",H\u000fZ8x]\"A\u0011qVA\u000b\t\u0013\t9+\u0001\u0007dY\u0016\fgn\u0014:TY\u0016,\u0007\u000f\u0003\u0005\u00024\u0006UA\u0011AA[\u0003-\u0011XmY8sIN#\u0018\r^:\u0015\u0019\u0005%\u0014qWA^\u0003\u0017\f).!7\t\u0011\u0005e\u0016\u0011\u0017a\u0001\u0003K\t!!\u001b3\t\u0011\u0005u\u0016\u0011\u0017a\u0001\u0003\u007f\u000bAA\\1nKB!\u0011\u0011YAd\u001d\rI\u00111Y\u0005\u0004\u0003\u000bT\u0011A\u0002)sK\u0012,g-\u0003\u0003\u0002B\u0005%'bAAc\u0015!A\u0011QZAY\u0001\u0004\ty-\u0001\u0003ge>l\u0007cA\u0005\u0002R&\u0019\u00111\u001b\u0006\u0003\t1{gn\u001a\u0005\t\u0003/\f\t\f1\u0001\u0002P\u0006\u0011Ao\u001c\u0005\t\u00037\f\t\f1\u0001\u0002^\u0005)1\u000f^1ug\"A\u0011q\u001c\u0001!\u0002\u0013\t\t!A\u0005dY\u0016\fg.\u001a:tA!9\u00111\u001d\u0001\u0005\u0002\u0005\u001d\u0016aB:uCJ$X\u000f\u001d\u0005\b\u0003W\u0003A\u0011AAT\u0011\u001d\tI\u000f\u0001C\u0001\u0003W\fQ\"\u00192peR\u001cE.Z1oS:<G\u0003BA5\u0003[Dq!!)\u0002h\u0002\u0007!\tC\u0004\u0002r\u0002!\t!a=\u0002#U\u0004H-\u0019;f\u0007\",7m\u001b9pS:$8\u000f\u0006\u0003\u0002j\u0005U\bbBA|\u0003_\u0004\rAM\u0001\bI\u0006$\u0018\rR5s\u0011\u001d\tY\u0010\u0001C\u0001\u0003{\f1\u0003[1oI2,Gj\\4ESJ4\u0015-\u001b7ve\u0016$B!!\u001b\u0002\u0000\"A!\u0011AA}\u0001\u0004\ty,A\u0002eSJDqA!\u0002\u0001\t\u0003\u00119!A\fnCf\u0014W\r\u0016:v]\u000e\fG/Z\"iK\u000e\\\u0007o\\5oiRA\u0011\u0011\u000eB\u0005\u0005\u0017\u0011i\u0001C\u0004\u0002x\n\r\u0001\u0019\u0001\u001a\t\u000f\u0005\u0005&1\u0001a\u0001\u0005\"A!q\u0002B\u0002\u0001\u0004\ty-\u0001\u0004pM\u001a\u001cX\r\u001e\u0005\b\u0005'\u0001A\u0011\u0001B\u000b\u0003U\t'm\u001c:u\u0003:$\u0007+Y;tK\u000ecW-\u00198j]\u001e$B!!\u001b\u0003\u0018!9\u0011\u0011\u0015B\t\u0001\u0004\u0011\u0005b\u0002B\u000e\u0001\u0011\u0005!QD\u0001\u000fe\u0016\u001cX/\\3DY\u0016\fg.\u001b8h)\u0011\tIGa\b\t\u000f\u0005\u0005&\u0011\u0004a\u0001\u0005\"9!1\u0005\u0001\u0005\u0002\t\u0015\u0012\u0001D1xC&$8\t\\3b]\u0016$G\u0003\u0003B\u0014\u0005[\u0011yC!\r\u0011\u0007%\u0011I#C\u0002\u0003,)\u0011qAQ8pY\u0016\fg\u000eC\u0004\u0002\"\n\u0005\u0002\u0019\u0001\"\t\u0011\t=!\u0011\u0005a\u0001\u0003\u001fD!Ba\r\u0003\"A\u0005\t\u0019AAh\u0003%i\u0017\r_,bSRl5\u000fC\u0005\u00038\u0001\t\n\u0011\"\u0001\u0003:\u00051\u0012m^1ji\u000ecW-\u00198fI\u0012\"WMZ1vYR$3'\u0006\u0002\u0003<)\"\u0011q\u001aB\u001fW\t\u0011y\u0004\u0005\u0003\u0003B\t-SB\u0001B\"\u0015\u0011\u0011)Ea\u0012\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B%\u0015\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t5#1\t\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,w!\u0003B)\u0005\u0005\u0005\t\u0012\u0001B*\u0003)aunZ\"mK\u0006tWM\u001d\t\u0004=\tUc\u0001C\u0001\u0003\u0003\u0003E\tAa\u0016\u0014\u0007\tU\u0003\u0002C\u0004f\u0005+\"\tAa\u0017\u0015\u0005\tM\u0003B\u0003B0\u0005+\n\n\u0011\"\u0001\u0003b\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIU*\"Aa\u0019+\u0007}\u0013i\u0004")
public class LogCleaner
implements KafkaMetricsGroup {
    private final CleanerConfig config;
    private final Seq<File> logDirs;
    private final Pool<TopicPartition, Log> logs;
    private final LogDirFailureChannel logDirFailureChannel;
    public final Time kafka$log$LogCleaner$$time;
    private final LogCleanerManager cleanerManager;
    private final Throttler kafka$log$LogCleaner$$throttler;
    private final IndexedSeq<CleanerThread> kafka$log$LogCleaner$$cleaners;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static Time $lessinit$greater$default$5() {
        return LogCleaner$.MODULE$.$lessinit$greater$default$5();
    }

    @Override
    public MetricName metricName(String name, Map<String, String> tags) {
        return KafkaMetricsGroup$class.metricName(this, name, tags);
    }

    @Override
    public MetricName explicitMetricName(String group, String typeName, String name, Map<String, String> tags) {
        return KafkaMetricsGroup$class.explicitMetricName(this, group, typeName, name, tags);
    }

    @Override
    public <T> Gauge<T> newGauge(String name, Gauge<T> metric, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newGauge(this, name, metric, tags);
    }

    @Override
    public Meter newMeter(String name, String eventType, TimeUnit timeUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newMeter(this, name, eventType, timeUnit, tags);
    }

    @Override
    public Histogram newHistogram(String name, boolean biased, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newHistogram(this, name, biased, tags);
    }

    @Override
    public Timer newTimer(String name, TimeUnit durationUnit, TimeUnit rateUnit, Map<String, String> tags) {
        return KafkaMetricsGroup$class.newTimer(this, name, durationUnit, rateUnit, tags);
    }

    @Override
    public void removeMetric(String name, Map<String, String> tags) {
        KafkaMetricsGroup$class.removeMetric(this, name, tags);
    }

    @Override
    public <T> Map<String, String> newGauge$default$3() {
        return KafkaMetricsGroup$class.newGauge$default$3(this);
    }

    @Override
    public Map<String, String> newMeter$default$4() {
        return KafkaMetricsGroup$class.newMeter$default$4(this);
    }

    @Override
    public Map<String, String> removeMetric$default$2() {
        return KafkaMetricsGroup$class.removeMetric$default$2(this);
    }

    @Override
    public Map<String, String> newTimer$default$4() {
        return KafkaMetricsGroup$class.newTimer$default$4(this);
    }

    @Override
    public boolean newHistogram$default$2() {
        return KafkaMetricsGroup$class.newHistogram$default$2(this);
    }

    @Override
    public Map<String, String> newHistogram$default$3() {
        return KafkaMetricsGroup$class.newHistogram$default$3(this);
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        LogCleaner logCleaner = this;
        synchronized (logCleaner) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging$class.msgWithLogIdent(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging$class.isDebugEnabled(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging$class.isTraceEnabled(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public CleanerConfig config() {
        return this.config;
    }

    public Seq<File> logDirs() {
        return this.logDirs;
    }

    public Pool<TopicPartition, Log> logs() {
        return this.logs;
    }

    public LogDirFailureChannel logDirFailureChannel() {
        return this.logDirFailureChannel;
    }

    public LogCleanerManager cleanerManager() {
        return this.cleanerManager;
    }

    public Throttler kafka$log$LogCleaner$$throttler() {
        return this.kafka$log$LogCleaner$$throttler;
    }

    public IndexedSeq<CleanerThread> kafka$log$LogCleaner$$cleaners() {
        return this.kafka$log$LogCleaner$$cleaners;
    }

    public void startup() {
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Starting the log cleaner";
            }
        });
        this.kafka$log$LogCleaner$$cleaners().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(CleanerThread x$9) {
                x$9.start();
            }
        });
    }

    public void shutdown() {
        this.info((Function0<String>)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "Shutting down the log cleaner.";
            }
        });
        this.kafka$log$LogCleaner$$cleaners().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(CleanerThread x$10) {
                x$10.shutdown();
            }
        });
    }

    public void abortCleaning(TopicPartition topicPartition) {
        this.cleanerManager().abortCleaning(topicPartition);
    }

    public void updateCheckpoints(File dataDir) {
        this.cleanerManager().updateCheckpoints(dataDir, (Option<Tuple2<TopicPartition, Object>>)None$.MODULE$);
    }

    public void handleLogDirFailure(String dir) {
        this.cleanerManager().handleLogDirFailure(dir);
    }

    public void maybeTruncateCheckpoint(File dataDir, TopicPartition topicPartition, long offset2) {
        this.cleanerManager().maybeTruncateCheckpoint(dataDir, topicPartition, offset2);
    }

    public void abortAndPauseCleaning(TopicPartition topicPartition) {
        this.cleanerManager().abortAndPauseCleaning(topicPartition);
    }

    public void resumeCleaning(TopicPartition topicPartition) {
        this.cleanerManager().resumeCleaning(topicPartition);
    }

    public boolean awaitCleaned(TopicPartition topicPartition, long offset2, long maxWaitMs) {
        long sleepTime;
        for (long remainingWaitMs = maxWaitMs; !this.isCleaned$1(topicPartition, offset2) && remainingWaitMs > 0L; remainingWaitMs -= sleepTime) {
            sleepTime = package$.MODULE$.min(100L, remainingWaitMs);
            Thread.sleep(sleepTime);
        }
        return this.isCleaned$1(topicPartition, offset2);
    }

    public long awaitCleaned$default$3() {
        return 60000L;
    }

    private final boolean isCleaned$1(TopicPartition topicPartition$1, long offset$1) {
        return BoxesRunTime.unboxToBoolean((Object)this.cleanerManager().allCleanerCheckpoints().get((Object)topicPartition$1).fold((Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return false;
            }
        }, (Function1)new Serializable(this, offset$1){
            public static final long serialVersionUID = 0L;
            private final long offset$1;

            public final boolean apply(long x$11) {
                return this.apply$mcZJ$sp(x$11);
            }

            public boolean apply$mcZJ$sp(long x$11) {
                return x$11 >= this.offset$1;
            }
            {
                this.offset$1 = offset$1;
            }
        }));
    }

    public LogCleaner(CleanerConfig config, Seq<File> logDirs, Pool<TopicPartition, Log> logs, LogDirFailureChannel logDirFailureChannel, Time time) {
        this.config = config;
        this.logDirs = logDirs;
        this.logs = logs;
        this.logDirFailureChannel = logDirFailureChannel;
        this.kafka$log$LogCleaner$$time = time;
        Logging$class.$init$(this);
        KafkaMetricsGroup$class.$init$(this);
        this.cleanerManager = new LogCleanerManager(logDirs, logs, logDirFailureChannel);
        this.kafka$log$LogCleaner$$throttler = new Throttler(config.maxIoBytesPerSecond(), 300L, true, "cleaner-io", "bytes", time);
        this.kafka$log$LogCleaner$$cleaners = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), config.numThreads()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleaner $outer;

            public final CleanerThread apply(int x$1) {
                return this.$outer.new CleanerThread(x$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        this.newGauge("max-buffer-utilization-percent", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public int value() {
                return (int)BoxesRunTime.unboxToDouble((Object)((TraversableOnce)((TraversableLike)this.$outer.kafka$log$LogCleaner$$cleaners().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CleanerStats apply(CleanerThread x$2) {
                        return x$2.lastStats();
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(CleanerStats x$3) {
                        return (double)100 * x$3.bufferUtilization();
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Double$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.newGauge("cleaner-recopy-percent", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public int value() {
                IndexedSeq stats = (IndexedSeq)this.$outer.kafka$log$LogCleaner$$cleaners().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CleanerStats apply(CleanerThread x$4) {
                        return x$4.lastStats();
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
                double recopyRate = (double)BoxesRunTime.unboxToLong((Object)((TraversableOnce)stats.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(CleanerStats x$5) {
                        return x$5.bytesWritten();
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) / (double)package$.MODULE$.max(BoxesRunTime.unboxToLong((Object)((TraversableOnce)stats.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(CleanerStats x$6) {
                        return x$6.bytesRead();
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)), 1L);
                return (int)((double)100 * recopyRate);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
        this.newGauge("max-clean-time-secs", new Gauge<Object>(this){
            private final /* synthetic */ LogCleaner $outer;

            public int value() {
                return (int)BoxesRunTime.unboxToDouble((Object)((TraversableOnce)((TraversableLike)this.$outer.kafka$log$LogCleaner$$cleaners().map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final CleanerStats apply(CleanerThread x$7) {
                        return x$7.lastStats();
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final double apply(CleanerStats x$8) {
                        return x$8.elapsedSecs();
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Double$.MODULE$));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, this.newGauge$default$3());
    }

    public class CleanerThread
    extends ShutdownableThread {
        private final String loggerName;
        private final Cleaner cleaner;
        private volatile CleanerStats lastStats;
        private final CountDownLatch backOffWaitLatch;

        @Override
        public String loggerName() {
            return this.loggerName;
        }

        public Cleaner cleaner() {
            return this.cleaner;
        }

        public CleanerStats lastStats() {
            return this.lastStats;
        }

        public void lastStats_$eq(CleanerStats x$1) {
            this.lastStats = x$1;
        }

        private CountDownLatch backOffWaitLatch() {
            return this.backOffWaitLatch;
        }

        public void kafka$log$LogCleaner$CleanerThread$$checkDone(TopicPartition topicPartition) {
            if (this.isRunning().get()) {
                this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().checkCleaningAborted(topicPartition);
                return;
            }
            throw new ThreadShutdownException();
        }

        @Override
        public void doWork() {
            this.cleanOrSleep();
        }

        @Override
        public void shutdown() {
            this.initiateShutdown();
            this.backOffWaitLatch().countDown();
            this.awaitShutdown();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void cleanOrSleep() {
            boolean bl;
            Option<LogToClean> option = this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().grabFilthiestCompactedLog(this.kafka$log$LogCleaner$CleanerThread$$$outer().kafka$log$LogCleaner$$time);
            if (None$.MODULE$.equals(option)) {
                bl = false;
            } else {
                if (!(option instanceof Some)) throw new MatchError(option);
                Some some = (Some)option;
                LogToClean cleanable = (LogToClean)some.x();
                long endOffset = cleanable.firstDirtyOffset();
                try {
                    Tuple2 tuple22;
                    Tuple2<Object, CleanerStats> tuple2 = this.cleaner().clean(cleanable);
                    if (tuple2 == null) throw new MatchError(tuple2);
                    long nextDirtyOffset = tuple2._1$mcJ$sp();
                    CleanerStats cleanerStats = (CleanerStats)tuple2._2();
                    Tuple2 tuple23 = tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)nextDirtyOffset), (Object)cleanerStats);
                    long nextDirtyOffset2 = tuple23._1$mcJ$sp();
                    CleanerStats cleanerStats2 = (CleanerStats)tuple23._2();
                    this.recordStats(this.cleaner().id(), cleanable.log().name(), cleanable.firstDirtyOffset(), endOffset, cleanerStats2);
                    endOffset = nextDirtyOffset2;
                }
                catch (IOException iOException) {
                    String msg = new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to clean up log for ", " in dir ", " due to IOException"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cleanable.topicPartition(), cleanable.log().dir().getParent()}));
                    this.kafka$log$LogCleaner$CleanerThread$$$outer().logDirFailureChannel().maybeAddOfflineLogDir(cleanable.log().dir().getParent(), (Function0<String>)new Serializable(this, msg){
                        public static final long serialVersionUID = 0L;
                        private final String msg$1;

                        public final String apply() {
                            return this.msg$1;
                        }
                        {
                            this.msg$1 = msg$1;
                        }
                    }, iOException);
                }
                catch (KafkaStorageException kafkaStorageException) {
                }
                catch (LogCleaningAbortedException logCleaningAbortedException) {
                }
                finally {
                    this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().doneCleaning(cleanable.topicPartition(), cleanable.log().dir().getParentFile(), endOffset);
                }
                bl = true;
            }
            boolean cleaned = bl;
            Iterable<Tuple2<TopicPartition, Log>> deletable = this.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().deletableLogs();
            deletable.foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CleanerThread $outer;

                public final int apply(Tuple2<TopicPartition, Log> x0$1) {
                    TopicPartition topicPartition;
                    Tuple2<TopicPartition, Log> tuple2 = x0$1;
                    if (tuple2 != null) {
                        topicPartition = (TopicPartition)tuple2._1();
                        Log log = (Log)tuple2._2();
                        int n = log.deleteOldSegments();
                        return n;
                    }
                    throw new MatchError(tuple2);
                    finally {
                        this.$outer.kafka$log$LogCleaner$CleanerThread$$$outer().cleanerManager().doneDeleting(topicPartition);
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            if (cleaned) return;
            this.backOffWaitLatch().await(this.kafka$log$LogCleaner$CleanerThread$$$outer().config().backOffMs(), TimeUnit.MILLISECONDS);
        }

        public void recordStats(int id, String name, long from, long to, CleanerStats stats) {
            this.lastStats_$eq(stats);
            String message = new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("%n\tLog cleaner thread %d cleaned log %s (dirty section = [%d, %d])%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)id), name, BoxesRunTime.boxToLong((long)from), BoxesRunTime.boxToLong((long)to)}))).append((Object)new StringOps(Predef$.MODULE$.augmentString("\t%,.1f MB of log processed in %,.1f seconds (%,.1f MB/sec).%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.mb$1(stats.bytesRead())), BoxesRunTime.boxToDouble((double)stats.elapsedSecs()), BoxesRunTime.boxToDouble((double)this.mb$1((double)stats.bytesRead() / stats.elapsedSecs()))}))).append((Object)new StringOps(Predef$.MODULE$.augmentString("\tIndexed %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.mb$1(stats.mapBytesRead())), BoxesRunTime.boxToDouble((double)stats.elapsedIndexSecs()), BoxesRunTime.boxToDouble((double)(this.mb$1(stats.mapBytesRead()) / stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)((double)100 * stats.elapsedIndexSecs() / stats.elapsedSecs()))}))).append((Object)new StringOps(Predef$.MODULE$.augmentString("\tBuffer utilization: %.1f%%%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)100 * stats.bufferUtilization()))}))).append((Object)new StringOps(Predef$.MODULE$.augmentString("\tCleaned %,.1f MB in %.1f seconds (%,.1f Mb/sec, %.1f%% of total time)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.mb$1(stats.bytesRead())), BoxesRunTime.boxToDouble((double)(stats.elapsedSecs() - stats.elapsedIndexSecs())), BoxesRunTime.boxToDouble((double)(this.mb$1(stats.bytesRead()) / (stats.elapsedSecs() - stats.elapsedIndexSecs()))), BoxesRunTime.boxToDouble((double)((double)100 * (stats.elapsedSecs() - stats.elapsedIndexSecs()) / stats.elapsedSecs()))}))).append((Object)new StringOps(Predef$.MODULE$.augmentString("\tStart size: %,.1f MB (%,d messages)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.mb$1(stats.bytesRead())), BoxesRunTime.boxToLong((long)stats.messagesRead())}))).append((Object)new StringOps(Predef$.MODULE$.augmentString("\tEnd size: %,.1f MB (%,d messages)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)this.mb$1(stats.bytesWritten())), BoxesRunTime.boxToLong((long)stats.messagesWritten())}))).append((Object)new StringOps(Predef$.MODULE$.augmentString("\t%.1f%% size reduction (%.1f%% fewer messages)%n")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.bytesWritten() / (double)stats.bytesRead()))), BoxesRunTime.boxToDouble((double)(100.0 * (1.0 - (double)stats.messagesWritten() / (double)stats.messagesRead())))}))).toString();
            this.info((Function0<String>)new Serializable(this, message){
                public static final long serialVersionUID = 0L;
                private final String message$1;

                public final String apply() {
                    return this.message$1;
                }
                {
                    this.message$1 = message$1;
                }
            });
            if (stats.invalidMessagesRead() > 0L) {
                this.warn((Function0<String>)new Serializable(this, stats){
                    public static final long serialVersionUID = 0L;
                    private final CleanerStats stats$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("\tFound %d invalid messages during compaction.")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.stats$1.invalidMessagesRead())}));
                    }
                    {
                        this.stats$1 = stats$1;
                    }
                });
            }
        }

        public /* synthetic */ LogCleaner kafka$log$LogCleaner$CleanerThread$$$outer() {
            return LogCleaner.this;
        }

        private final double mb$1(double bytes) {
            return bytes / (double)0x100000;
        }

        public CleanerThread(int threadId) {
            if (LogCleaner.this == null) {
                throw null;
            }
            super(new StringBuilder().append((Object)"kafka-log-cleaner-thread-").append((Object)BoxesRunTime.boxToInteger((int)threadId)).toString(), false);
            this.loggerName = LogCleaner.class.getName();
            if (LogCleaner.this.config().dedupeBufferSize() / (long)LogCleaner.this.config().numThreads() > Integer.MAX_VALUE) {
                this.warn((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Cannot use more than 2G of cleaner buffer space per cleaner thread, ignoring excess buffer space...";
                    }
                });
            }
            this.cleaner = new Cleaner(threadId, new SkimpyOffsetMap((int)package$.MODULE$.min(LogCleaner.this.config().dedupeBufferSize() / (long)LogCleaner.this.config().numThreads(), Integer.MAX_VALUE), LogCleaner.this.config().hashAlgorithm()), LogCleaner.this.config().ioBufferSize() / LogCleaner.this.config().numThreads() / 2, LogCleaner.this.config().maxMessageSize(), LogCleaner.this.config().dedupeBufferLoadFactor(), LogCleaner.this.kafka$log$LogCleaner$$throttler(), LogCleaner.this.kafka$log$LogCleaner$$time, (Function1<TopicPartition, BoxedUnit>)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CleanerThread $outer;

                public final void apply(TopicPartition topicPartition) {
                    this.$outer.kafka$log$LogCleaner$CleanerThread$$checkDone(topicPartition);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            });
            this.lastStats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
            this.backOffWaitLatch = new CountDownLatch(1);
        }
    }
}

