/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project.artifact;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.ArtifactStatus;
import org.apache.maven.artifact.metadata.AbstractArtifactMetadata;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.model.DistributionManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class ProjectArtifactMetadata
extends AbstractArtifactMetadata {
    private final File file;

    public ProjectArtifactMetadata(Artifact artifact, File file) {
        super(artifact);
        this.file = file;
    }

    public String getRemoteFilename() {
        return this.getFilename();
    }

    public String getLocalFilename(ArtifactRepository repository) {
        return this.getFilename();
    }

    private String getFilename() {
        return this.getArtifactId() + "-" + this.artifact.getVersion() + ".pom";
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void storeInLocalRepository(ArtifactRepository localRepository, ArtifactRepository remoteRepository) throws ArtifactMetadataRetrievalException {
        File destination = new File(localRepository.getBasedir(), localRepository.pathOfLocalRepositoryMetadata((ArtifactMetadata)this, remoteRepository));
        destination.getParentFile().mkdirs();
        FileReader reader = null;
        FileWriter writer = null;
        try {
            reader = new FileReader(this.file);
            writer = new FileWriter(destination);
            MavenXpp3Reader modelReader = new MavenXpp3Reader();
            Model model = modelReader.read((Reader)reader);
            model.setVersion(this.artifact.getVersion());
            DistributionManagement distributionManagement = model.getDistributionManagement();
            if (distributionManagement == null) {
                distributionManagement = new DistributionManagement();
                model.setDistributionManagement(distributionManagement);
            }
            distributionManagement.setStatus(ArtifactStatus.DEPLOYED.toString());
            MavenXpp3Writer modelWriter = new MavenXpp3Writer();
            modelWriter.write((Writer)writer, model);
        }
        catch (FileNotFoundException e) {
            try {
                throw new ArtifactMetadataRetrievalException("Error rewriting POM", (Throwable)e);
                catch (IOException e2) {
                    throw new ArtifactMetadataRetrievalException("Error rewriting POM", (Throwable)e2);
                }
                catch (XmlPullParserException e3) {
                    throw new ArtifactMetadataRetrievalException("Error rewriting POM", (Throwable)e3);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(reader);
                IOUtil.close(writer);
                throw throwable;
            }
        }
        IOUtil.close((Reader)reader);
        IOUtil.close((Writer)writer);
    }

    public String toString() {
        return "project information for " + this.artifact.getArtifactId() + " " + this.artifact.getVersion();
    }

    public boolean storedInArtifactVersionDirectory() {
        return true;
    }

    public String getBaseVersion() {
        return this.artifact.getBaseVersion();
    }

    public Object getKey() {
        return "project " + this.artifact.getGroupId() + ":" + this.artifact.getArtifactId();
    }

    public void merge(ArtifactMetadata metadata) {
        ProjectArtifactMetadata m = (ProjectArtifactMetadata)metadata;
        if (!m.file.equals(this.file)) {
            throw new IllegalStateException("Cannot add two different pieces of metadata for: " + this.getKey());
        }
    }
}

