/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.was6;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.codehaus.mojo.was6.AbstractEjbMojo;
import org.dom4j.Document;

public class EjbDeployMojo
extends AbstractEjbMojo {
    private MavenProject executedProject;
    private boolean noValidate;
    private boolean noWarnings;
    private boolean noInform;
    private boolean legacyMode;
    private String dbname;
    private String dbschema;
    private String dbvendor;
    private boolean dynamic;
    private boolean compatible35;
    private boolean sqlj;
    private String classifier;
    private File basedir;
    private String jarName;
    private MavenProjectHelper projectHelper;
    private String jdkComplianceLevel;
    private String wasVersion;

    protected File getOutputJarFile() {
        if (this.classifier == null) {
            this.classifier = "";
        } else if (this.classifier.trim().length() > 0 && !this.classifier.startsWith("-")) {
            this.classifier = "-" + this.classifier;
        }
        File outputJarFile = new File(this.getWorkingDirectory(), this.executedProject.getArtifact().getArtifactId() + this.classifier + "-deployed.jar");
        return outputJarFile;
    }

    protected String getTaskName() {
        return "wsEjbDeploy";
    }

    protected void configureBuildScript(Document document) throws MojoExecutionException {
        document.getRootElement().addElement("property").addAttribute("name", "user.install.root").addAttribute("location", this.getWasHome().getAbsolutePath());
        File inputFile = EjbDeployMojo.getEJBJarFile(this.basedir, this.jarName, this.classifier);
        if (!inputFile.canRead()) {
            throw new MojoExecutionException("Invalid archive: " + inputFile.getAbsolutePath());
        }
        this.configureTaskAttribute(document, "inputJar", inputFile.getAbsolutePath());
        this.configureTaskAttribute(document, "outputJar", this.getOutputJarFile());
        this.configureTaskAttribute(document, "workingDirectory", this.getWorkingDirectory().getAbsolutePath());
        this.configureTaskAttribute(document, "trace", Boolean.toString(this.isVerbose()));
        this.configureTaskAttribute(document, "noInform", Boolean.toString(this.noInform));
        this.configureTaskAttribute(document, "noWarnings", Boolean.toString(this.noWarnings));
        this.configureTaskAttribute(document, "noValidate", Boolean.toString(this.noValidate));
        this.configureTaskAttribute(document, "classpath", this.getRuntimeClasspath());
        this.configureTaskAttribute(document, "dbname", this.dbname);
        this.configureTaskAttribute(document, "dbvendor", this.dbvendor);
        this.configureTaskAttribute(document, "dbschema", this.dbschema);
        this.configureTaskAttribute(document, "dynamic", Boolean.toString(this.dynamic));
        this.configureTaskAttribute(document, "compatible35", Boolean.toString(this.compatible35));
        this.configureTaskAttribute(document, "sqlj", Boolean.toString(this.sqlj));
        if (this.legacyMode) {
            this.getLog().warn((CharSequence)"Legacy mode - jdkComplianceLevel will NOT be taken into consideration (default will be used)");
            this.configureTaskAttribute(document, "jdkComplianceLevel", null);
        } else {
            this.configureTaskAttribute(document, "jdkComplianceLevel", "1.5".equals(this.jdkComplianceLevel) ? "5.0" : this.jdkComplianceLevel);
        }
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (!this.isSkip()) {
            if (!this.getMavenProject().getPackaging().equalsIgnoreCase("ejb")) {
                throw new MojoExecutionException("Invalid packaging type, this plugin can only be applied to ejb packaging type projects");
            }
            super.execute();
            if (!this.getOutputJarFile().exists()) {
                throw new MojoExecutionException("Deployment failed - see previous errors");
            }
            File[] workingDirectorySubdirs = this.getWorkingDirectory().listFiles((FileFilter)DirectoryFileFilter.DIRECTORY);
            if (workingDirectorySubdirs.length == 1) {
                if (!"was60".equalsIgnoreCase(this.wasVersion)) {
                    this.processWas61(workingDirectorySubdirs);
                } else {
                    this.processWas60(workingDirectorySubdirs);
                }
            } else {
                this.getLog().warn((CharSequence)"No sources were generated");
            }
            this.getLog().info((CharSequence)"ejbDeploy finished");
        } else {
            this.getLog().info((CharSequence)"Skipping execution");
        }
    }

    private String getRuntimeClasspath() throws MojoExecutionException {
        try {
            HashSet dependencySet = new HashSet();
            dependencySet.addAll(this.getMavenProject().getCompileClasspathElements());
            dependencySet.addAll(this.getMavenProject().getRuntimeClasspathElements());
            String compileClasspath = StringUtils.join(dependencySet, (String)File.pathSeparator);
            return compileClasspath;
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private static File getEJBJarFile(File basedir, String finalName, String classifier) {
        if (classifier == null) {
            classifier = "";
        } else if (classifier.trim().length() > 0 && !classifier.startsWith("-")) {
            classifier = "-" + classifier;
        }
        File f = new File(basedir, finalName + classifier + ".jar");
        return f;
    }

    private void processWas61(File[] workingDirectorySubdirs) throws MojoExecutionException {
        File generatedSources = new File(workingDirectorySubdirs[0], this.getMavenProject().getBuild().getFinalName() + this.classifier + File.separator + "ejbModule");
        try {
            FileUtils.copyDirectory((File)generatedSources, (File)this.getGeneratedSourcesDirectory());
            FileUtils.deleteDirectory((File)new File(this.getGeneratedSourcesDirectory(), "META-INF"));
            List compileSourceRoots = this.getMavenProject().getCompileSourceRoots();
            compileSourceRoots.add(this.getGeneratedSourcesDirectory().getPath());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error copying generated sources", (Exception)e);
        }
        File generatedClasses = new File(workingDirectorySubdirs[0], this.getMavenProject().getBuild().getFinalName() + this.classifier + File.separator + "build" + File.separator + "classes");
        try {
            FileUtils.copyDirectory((File)generatedClasses, (File)this.getGeneratedClassesDirectory());
            Resource resource = new Resource();
            resource.setDirectory(this.getGeneratedClassesDirectory().getPath());
            this.getMavenProject().getResources().add(resource);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error copying generated classes", (Exception)e);
        }
    }

    private void processWas60(File[] workingDirectorySubdirs) {
        File[] workspaceSubdirs = workingDirectorySubdirs[0].listFiles((FileFilter)DirectoryFileFilter.DIRECTORY);
        this.getLog().debug((CharSequence)("getWorkingDirectory()                       : " + this.getWorkingDirectory()));
        this.getLog().debug((CharSequence)("getMavenProject().getBuild().getFinalName() : " + this.getMavenProject().getBuild().getFinalName()));
        this.getLog().debug((CharSequence)("workingDirectorySubdirs[0]                  : " + workingDirectorySubdirs[0]));
        this.getLog().debug((CharSequence)("workspaceSubdirs[0]                         : " + workspaceSubdirs[0]));
        this.getLog().debug((CharSequence)("workspaceSubdirs[1]                         : " + workspaceSubdirs[1]));
        if (workspaceSubdirs.length == 2) {
            File generatedSources = new File(workspaceSubdirs[1], "ejbModule");
            try {
                FileUtils.copyDirectory((File)generatedSources, (File)this.getGeneratedSourcesDirectory());
                FileUtils.deleteDirectory((File)new File(this.getGeneratedSourcesDirectory(), "META-INF"));
                List compileSourceRoots = this.getMavenProject().getCompileSourceRoots();
                compileSourceRoots.add(this.getGeneratedSourcesDirectory().getPath());
                String[] extensions = new String[]{"class"};
                this.cleanupFiles(this.getGeneratedSourcesDirectory(), extensions);
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)"Error copying generated sources");
            }
            File generatedClasses = new File(workspaceSubdirs[1], "ejbModule");
            try {
                FileUtils.copyDirectory((File)generatedClasses, (File)this.getGeneratedClassesDirectory());
                Resource resource = new Resource();
                resource.setDirectory(this.getGeneratedClassesDirectory().getPath());
                this.getMavenProject().getResources().add(resource);
                String[] extensions = new String[]{"java"};
                this.cleanupFiles(this.getGeneratedClassesDirectory(), extensions);
            }
            catch (IOException e) {
                this.getLog().warn((CharSequence)"Error copying generated classes");
            }
        } else {
            this.getLog().warn((CharSequence)"Unable to make sense of ejbDeploy workbench directory output.");
        }
    }

    private void cleanupFiles(File directory, String[] extensions) {
        Collection cFiles = FileUtils.listFiles((File)directory, (String[])extensions, (boolean)true);
        File[] files = FileUtils.convertFileCollectionToFileArray((Collection)cFiles);
        this.getLog().debug((CharSequence)("files.length                                : " + files.length));
        for (int i = 0; i < files.length; ++i) {
            this.getLog().debug((CharSequence)("deleting file                               : " + files[i].getPath()));
            files[i].delete();
        }
    }
}

