/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging;

import java.util.List;
import java.util.ResourceBundle;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ParameterCorrector;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.operations.validation.AllowedValuesValidator;
import org.jboss.as.controller.operations.validation.MinMaxValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.logging.validators.ObjectTypeValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class ObjectTypeAttributeDefinition
extends SimpleAttributeDefinition {
    private final AttributeDefinition[] valueTypes;
    private final String suffix;

    private ObjectTypeAttributeDefinition(String name, String xmlName, String suffix, AttributeDefinition[] valueTypes, boolean allowNull, ParameterCorrector corrector, String[] alternatives, String[] requires, AttributeAccess.Flag ... flags) {
        super(name, xmlName, null, ModelType.OBJECT, allowNull, false, null, corrector, (ParameterValidator)new ObjectTypeValidator(allowNull, valueTypes), alternatives, requires, flags);
        this.valueTypes = valueTypes;
        this.suffix = suffix == null ? "" : suffix;
    }

    public ModelNode parse(String value, XMLStreamReader reader) throws XMLStreamException {
        throw new UnsupportedOperationException();
    }

    public ModelNode addResourceAttributeDescription(ResourceBundle bundle2, String prefix, ModelNode resourceDescription) {
        ModelNode result = super.addResourceAttributeDescription(bundle2, prefix, resourceDescription);
        this.addValueTypeDescription(result, prefix, bundle2);
        return result;
    }

    public ModelNode addOperationParameterDescription(ResourceBundle bundle2, String prefix, ModelNode operationDescription) {
        ModelNode result = super.addOperationParameterDescription(bundle2, prefix, operationDescription);
        this.addValueTypeDescription(result, prefix, bundle2);
        return result;
    }

    protected void addValueTypeDescription(ModelNode node, String prefix, ResourceBundle bundle2) {
        for (AttributeDefinition valueType : this.valueTypes) {
            ModelNode valueTypeDesc = this.getValueTypeDescription(valueType, false);
            String p = prefix == null || prefix.isEmpty() ? this.suffix : String.format("%s.%s", prefix, this.suffix);
            valueTypeDesc.get("description").set(valueType.getAttributeTextDescription(bundle2, p));
            ModelNode childType = node.get(new String[]{"value-type", valueType.getName()}).set(valueTypeDesc);
            if (!(valueType instanceof ObjectTypeAttributeDefinition)) continue;
            ((ObjectTypeAttributeDefinition)((Object)ObjectTypeAttributeDefinition.class.cast(valueType))).addValueTypeDescription(childType, prefix, bundle2);
        }
    }

    public void marshallAsElement(ModelNode resourceModel, XMLStreamWriter writer) throws XMLStreamException {
        if (resourceModel.hasDefined(this.getName())) {
            writer.writeStartElement(this.getXmlName());
            for (AttributeDefinition valueType : this.valueTypes) {
                for (ModelNode handler : resourceModel.get(this.getName()).asList()) {
                    valueType.marshallAsElement(handler, writer);
                }
            }
            writer.writeEndElement();
        }
    }

    private ModelNode getValueTypeDescription(AttributeDefinition valueType, boolean forOperation) {
        AllowedValuesValidator avv;
        List allowed;
        ParameterValidator validator;
        String[] requires;
        String[] alternatives;
        MeasurementUnit measurementUnit;
        ModelNode result = new ModelNode();
        result.get("type").set(valueType.getType());
        result.get("description");
        result.get("expressions-allowed").set(valueType.isAllowExpression());
        if (forOperation) {
            result.get("required").set(!valueType.isAllowNull());
        }
        result.get("nillable").set(this.isAllowNull());
        ModelNode defaultValue = valueType.getDefaultValue();
        if (!forOperation && defaultValue != null && defaultValue.isDefined()) {
            result.get("default").set(defaultValue);
        }
        if ((measurementUnit = valueType.getMeasurementUnit()) != null && measurementUnit != MeasurementUnit.NONE) {
            result.get("unit").set(measurementUnit.getName());
        }
        if ((alternatives = valueType.getAlternatives()) != null) {
            for (String alternative : alternatives) {
                result.get("alternatives").add(alternative);
            }
        }
        if ((requires = valueType.getRequires()) != null) {
            for (String required : requires) {
                result.get("requires").add(required);
            }
        }
        if ((validator = valueType.getValidator()) instanceof MinMaxValidator) {
            Long max;
            MinMaxValidator minMax = (MinMaxValidator)validator;
            Long min = minMax.getMin();
            if (min != null) {
                switch (valueType.getType()) {
                    case STRING: 
                    case LIST: 
                    case OBJECT: {
                        result.get("min-length").set(min.longValue());
                        break;
                    }
                    default: {
                        result.get("min").set(min.longValue());
                    }
                }
            }
            if ((max = minMax.getMax()) != null) {
                switch (valueType.getType()) {
                    case STRING: 
                    case LIST: 
                    case OBJECT: {
                        result.get("max-length").set(max.longValue());
                        break;
                    }
                    default: {
                        result.get("max").set(max.longValue());
                    }
                }
            }
        }
        if (validator instanceof AllowedValuesValidator && (allowed = (avv = (AllowedValuesValidator)validator).getAllowedValues()) != null) {
            for (ModelNode ok : allowed) {
                result.get("allowed").add(ok);
            }
        }
        return result;
    }

    public static class Builder {
        private final String name;
        private String suffix;
        private final AttributeDefinition[] valueTypes;
        private ParameterCorrector corrector;
        private String xmlName;
        private boolean allowNull;
        private String[] alternatives;
        private String[] requires;
        private AttributeAccess.Flag[] flags;

        public Builder(String name, AttributeDefinition ... valueTypes) {
            this.name = name;
            this.valueTypes = valueTypes;
            this.allowNull = true;
        }

        public static Builder of(String name, AttributeDefinition ... valueTypes) {
            return new Builder(name, valueTypes);
        }

        public ObjectTypeAttributeDefinition build() {
            if (this.xmlName == null) {
                this.xmlName = this.name;
            }
            return new ObjectTypeAttributeDefinition(this.name, this.xmlName, this.suffix, this.valueTypes, this.allowNull, this.corrector, this.alternatives, this.requires, this.flags);
        }

        public Builder setAllowNull(boolean allowNull) {
            this.allowNull = allowNull;
            return this;
        }

        public Builder setAlternates(String ... alternates) {
            this.alternatives = alternates;
            return this;
        }

        public Builder setCorrector(ParameterCorrector corrector) {
            this.corrector = corrector;
            return this;
        }

        public Builder setFlags(AttributeAccess.Flag ... flags) {
            this.flags = flags;
            return this;
        }

        public Builder setRequires(String ... requires) {
            this.requires = requires;
            return this;
        }

        public Builder setSuffix(String suffix) {
            this.suffix = suffix;
            return this;
        }

        public Builder setXmlName(String xmlName) {
            this.xmlName = xmlName;
            return this;
        }
    }
}

