/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.loggers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Handler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.LoggingLogger;
import org.jboss.as.logging.LoggingMessages;
import org.jboss.as.logging.loggers.AbstractLogHandlerAssignmentHandler;
import org.jboss.as.logging.loggers.LoggerHandlerService;
import org.jboss.as.logging.util.LogServices;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.logmanager.Logger;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;

public class LoggerAssignHandler
extends AbstractLogHandlerAssignmentHandler {
    public static final String OPERATION_NAME = "assign-handler";
    public static final LoggerAssignHandler INSTANCE = new LoggerAssignHandler();

    protected void updateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        this.updateHandlersForAssign((AttributeDefinition)CommonAttributes.HANDLERS, operation, model);
    }

    @Override
    protected String getHandlerName(ModelNode operation) throws OperationFailedException {
        return CommonAttributes.NAME.validateOperation(operation).asString();
    }

    protected String getLoggerName(ModelNode operation) {
        PathAddress address = PathAddress.pathAddress((ModelNode)operation.require("address"));
        return address.getLastElement().getValue();
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        String loggerName = this.getLoggerName(operation);
        String handlerName = this.getHandlerName(operation);
        newControllers.add(LoggerAssignHandler.addHandler(context, loggerName, handlerName, verificationHandler));
    }

    public static ServiceController<Logger> addHandler(OperationContext context, String loggerName, String handlerName, ServiceVerificationHandler verificationHandler) throws OperationFailedException {
        ServiceRegistry serviceRegistry = context.getServiceRegistry(true);
        if (serviceRegistry.getService(LogServices.loggerName(loggerName)) == null) {
            throw LoggerAssignHandler.createFailureMessage(LoggingMessages.MESSAGES.loggerNotFound(loggerName));
        }
        ServiceController loggerHandlerController = serviceRegistry.getService(LogServices.loggerHandlerName(loggerName, handlerName));
        ServiceController handlerController = serviceRegistry.getService(LogServices.handlerName(handlerName));
        if (loggerHandlerController != null) {
            throw LoggerAssignHandler.createFailureMessage(LoggingMessages.MESSAGES.handlerAlreadyDefined(handlerName));
        }
        if (handlerController == null) {
            throw LoggerAssignHandler.createFailureMessage(LoggingMessages.MESSAGES.handlerNotFound(handlerName));
        }
        ServiceTarget target = context.getServiceTarget();
        LoggerHandlerService service = new LoggerHandlerService(loggerName);
        ServiceBuilder builder = target.addService(LogServices.loggerHandlerName(loggerName, handlerName), (Service)service);
        builder.addDependency(LogServices.loggerName(loggerName));
        builder.addDependency(LogServices.handlerName(handlerName), Handler.class, service.getHandlerInjector());
        if (verificationHandler != null) {
            builder.addListener((ServiceListener)verificationHandler);
        }
        return builder.install();
    }

    public static Collection<ServiceController<?>> installHandlers(ServiceTarget serviceTarget, String loggerName, ModelNode handlers, ServiceVerificationHandler verificationHandler) {
        ArrayList controllers = new ArrayList();
        for (ModelNode handler : handlers.asList()) {
            String handlerName = handler.asString();
            LoggerHandlerService service = new LoggerHandlerService(loggerName);
            Injector<Handler> injector = service.getHandlerInjector();
            ServiceName serviceName = LogServices.loggerHandlerName(loggerName, handlerName);
            ServiceName loggerDep = LogServices.loggerName(loggerName);
            ServiceName handlerDep = LogServices.handlerName(handlerName);
            LoggingLogger.ROOT_LOGGER.tracef("Installing service '%s' for logger '%s' with handler '%s'", serviceName, loggerDep, handlerDep);
            controllers.add(serviceTarget.addService(serviceName, (Service)service).addDependency(loggerDep).addDependency(handlerDep, Handler.class, injector).addListener((ServiceListener)verificationHandler).install());
        }
        return controllers;
    }

    public static List<ServiceController<?>> addHandlers(ModelNode handlers, OperationContext context, String loggerName, ServiceVerificationHandler verificationHandler) throws OperationFailedException {
        ArrayList controllers = new ArrayList();
        if (handlers.isDefined()) {
            if (context.getServiceRegistry(false).getService(LogServices.loggerName(loggerName)) == null) {
                throw LoggerAssignHandler.createFailureMessage(LoggingMessages.MESSAGES.loggerNotFound(loggerName));
            }
            if (handlers.getType() == ModelType.LIST) {
                for (ModelNode handler : handlers.asList()) {
                    controllers.add(LoggerAssignHandler.addHandler(context, loggerName, handler.asString(), verificationHandler));
                }
            }
        }
        return controllers;
    }
}

