/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.loggers;

import java.util.List;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.LoggingExtension;
import org.jboss.as.logging.loggers.LoggerAssignHandler;
import org.jboss.as.logging.loggers.RootLoggerService;
import org.jboss.as.logging.util.LogServices;
import org.jboss.as.logging.util.ModelParser;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceTarget;

public class RootLoggerAdd
extends AbstractAddStepHandler {
    public static final RootLoggerAdd INSTANCE = new RootLoggerAdd();
    public static final String OPERATION_NAME = "add";
    public static final String LEGACY_OPERATION_NAME = "set-root-logger";

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        CommonAttributes.LEVEL.validateAndSet(operation, model);
        CommonAttributes.FILTER.validateAndSet(operation, model);
        CommonAttributes.HANDLERS.validateAndSet(operation, model);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        PathAddress address = PathAddress.pathAddress((PathElement[])new PathElement[]{LoggingExtension.rootLoggerPath});
        String name = address.getLastElement().getValue();
        ModelNode level = CommonAttributes.LEVEL.resolveModelAttribute(context, model);
        ModelNode handlers = CommonAttributes.HANDLERS.resolveModelAttribute(context, model);
        ModelNode filter = CommonAttributes.FILTER.resolveModelAttribute(context, model);
        ServiceTarget target = context.getServiceTarget();
        RootLoggerService service = new RootLoggerService();
        if (level.isDefined()) {
            service.setLevel(ModelParser.parseLevel(level));
        }
        if (filter.isDefined()) {
            service.setFilter(ModelParser.parseFilter(context, filter));
        }
        ServiceBuilder builder = target.addService(LogServices.loggerName(name), (Service)service).setInitialMode(ServiceController.Mode.ACTIVE);
        if (verificationHandler != null) {
            builder.addListener((ServiceListener)verificationHandler);
        }
        ServiceController controller = builder.install();
        if (newControllers != null) {
            newControllers.add(controller);
        }
        if (handlers.isDefined()) {
            newControllers.addAll(LoggerAssignHandler.installHandlers(target, name, handlers, verificationHandler));
        }
    }
}

