/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.logging.loggers;

import java.util.List;
import org.jboss.as.controller.AbstractModelUpdateHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.logging.CommonAttributes;
import org.jboss.as.logging.util.LogServices;
import org.jboss.as.logging.util.ModelParser;
import org.jboss.dmr.ModelNode;
import org.jboss.logmanager.Logger;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceRegistry;

public class RootLoggerLevelChange
extends AbstractModelUpdateHandler {
    public static final String OPERATION_NAME = "change-root-log-level";
    public static final RootLoggerLevelChange INSTANCE = new RootLoggerLevelChange();

    protected void updateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        CommonAttributes.LEVEL.validateAndSet(operation, model.get("root-logger"));
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ServiceRegistry serviceRegistry = context.getServiceRegistry(false);
        ServiceController controller = serviceRegistry.getService(LogServices.ROOT_LOGGER);
        ModelNode level = CommonAttributes.LEVEL.resolveModelAttribute(context, model.get("root-logger"));
        if (controller != null && level.isDefined()) {
            ((Logger)controller.getValue()).setLevel(ModelParser.parseLevel(level));
        }
    }
}

