/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.plugin.deployment.resource;

import java.net.InetAddress;
import java.util.Map;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.OperationBuilder;
import org.jboss.as.plugin.deployment.common.AbstractServerConnection;
import org.jboss.dmr.ModelNode;

public class AddResource
extends AbstractServerConnection {
    public static final String GOAL = "add-resource";
    private String address;
    private Map<String, String> properties;
    private boolean force;

    @Override
    public String goal() {
        return GOAL;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            InetAddress host = this.hostAddress();
            this.getLog().info((CharSequence)String.format("Executing goal %s on server %s (%s) port %s.", this.goal(), host.getHostName(), host.getHostAddress(), this.port()));
            ModelControllerClient client = this.client();
            ModelNode request = new ModelNode();
            request.get("operation").set("read-resource");
            request.get("recursive").set(false);
            AddressPair childAddress = this.setupParentAddress(request);
            ModelNode r = client.execute(new OperationBuilder(request).build());
            this.reportFailure(r);
            boolean found = false;
            if (r.get("result").get(childAddress.type).isDefined()) {
                for (ModelNode modelNode : r.get("result").get(childAddress.type).asList()) {
                    if (!modelNode.asProperty().getName().equals(childAddress.name)) continue;
                    found = true;
                }
            }
            if (found && this.force) {
                request = new ModelNode();
                request.get("operation").set("remove");
                this.setupAddress(request);
                r = client.execute(new OperationBuilder(request).build());
                this.reportFailure(r);
            } else if (found && !this.force) {
                throw new RuntimeException("Resource " + this.address + " already exists ");
            }
            request = new ModelNode();
            request.get("operation").set("add");
            this.setupAddress(request);
            for (Map.Entry entry : this.properties.entrySet()) {
                String[] props = ((String)entry.getKey()).split(",");
                if (props.length == 0) {
                    throw new RuntimeException("Invalid property " + entry);
                }
                ModelNode node = request;
                for (int i = 0; i < props.length - 1; ++i) {
                    node = node.get(props[i]);
                }
                String value = (String)entry.getValue();
                if (value.startsWith("!!")) {
                    this.handleDmrString(node, props[props.length - 1], value);
                    continue;
                }
                node.get(props[props.length - 1]).set(value);
            }
            r = client.execute(new OperationBuilder(request).build());
            this.reportFailure(r);
        }
        catch (Exception e) {
            throw new MojoExecutionException(String.format("Could not execute goal %s. Reason: %s", this.goal(), e.getMessage()), e);
        }
    }

    private void handleDmrString(ModelNode node, String name, String value) {
        String realValue = value.substring(2);
        node.get(name).set(ModelNode.fromString((String)realValue));
    }

    private void setupAddress(ModelNode request) {
        String[] parts;
        for (String part : parts = this.address.split(",")) {
            String[] address = part.split("=");
            if (address.length != 2) {
                throw new RuntimeException(part + " is not a valid address segment");
            }
            request.get("address").add(address[0], address[1]);
        }
    }

    private void reportFailure(ModelNode node) {
        if (!node.get("outcome").asString().equals("success")) {
            throw new RuntimeException("Operation failed " + node);
        }
    }

    private AddressPair setupParentAddress(ModelNode request) {
        String[] parts = this.address.split(",");
        for (int i = 0; i < parts.length - 1; ++i) {
            String part = parts[i];
            String[] address = part.split("=");
            if (address.length != 2) {
                throw new RuntimeException(part + " is not a valid address segment");
            }
            request.get("address").add(address[0], address[1]);
        }
        String part = parts[parts.length - 1];
        String[] address = part.split("=");
        if (address.length != 2) {
            throw new RuntimeException(part + " is not a valid address segment");
        }
        return new AddressPair(address[0], address[1]);
    }

    private static class AddressPair {
        private final String name;
        private final String type;

        public AddressPair(String type, String name) {
            this.name = name;
            this.type = type;
        }
    }
}

