/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.plugin.server;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.plugin.server.SecurityActions;
import org.jboss.as.plugin.server.ServerConfig;

abstract class Server {
    private final ScheduledExecutorService timerService;
    private final ServerConfig serverConfig;
    private Process process;
    private ConsoleConsumer console;
    private final String shutdownId;

    protected Server(ServerConfig serverConfig) {
        this(serverConfig, null);
    }

    protected Server(ServerConfig serverConfig, String shutdownId) {
        this.serverConfig = serverConfig;
        this.shutdownId = shutdownId;
        this.timerService = Executors.newScheduledThreadPool(1);
    }

    protected final ConsoleConsumer getConsole() {
        return this.console;
    }

    public final synchronized void start() throws IOException {
        SecurityActions.registerShutdown(this);
        List<String> cmd = this.createLaunchCommand();
        ProcessBuilder processBuilder = new ProcessBuilder(cmd);
        processBuilder.redirectErrorStream(true);
        this.process = processBuilder.start();
        this.console = this.startConsoleConsumer(this.process.getInputStream(), this.shutdownId);
        long timeout = this.serverConfig.getStartupTimeout() * 1000L;
        boolean serverAvailable = false;
        long sleep = 50L;
        this.init();
        while (timeout > 0L && !serverAvailable) {
            serverAvailable = this.isRunning();
            if (serverAvailable) continue;
            if (Server.processHasDied(this.process)) break;
            try {
                Thread.sleep(sleep);
            }
            catch (InterruptedException e) {
                serverAvailable = false;
                break;
            }
            timeout -= sleep;
            sleep = Math.max(sleep / 2L, 100L);
        }
        if (!serverAvailable) {
            this.destroyProcess();
            throw new IllegalStateException(String.format("Managed server was not started within [%d] s", this.serverConfig.getStartupTimeout()));
        }
        this.timerService.scheduleWithFixedDelay(new Reaper(), 20L, 10L, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void stop() {
        try {
            this.stopServer();
        }
        finally {
            if (this.process != null) {
                this.process.destroy();
                try {
                    this.process.waitFor();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.timerService.shutdown();
        }
    }

    protected abstract void init() throws IOException;

    protected abstract void stopServer();

    public abstract boolean isRunning();

    public abstract ModelControllerClient getClient();

    protected abstract List<String> createLaunchCommand();

    protected abstract void checkServerState();

    private int destroyProcess() {
        if (this.process == null) {
            return 0;
        }
        this.process.destroy();
        try {
            return this.process.waitFor();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean processHasDied(Process process) {
        try {
            process.exitValue();
            return true;
        }
        catch (IllegalThreadStateException e) {
            return false;
        }
    }

    private ConsoleConsumer startConsoleConsumer(InputStream stream, String shutdownId) {
        ConsoleConsumer result = new ConsoleConsumer(stream, shutdownId);
        Thread t = new Thread(result);
        t.setName("AS7-Console");
        t.start();
        return result;
    }

    class ConsoleConsumer
    implements Runnable {
        private final InputStream in;
        private final String shutdownId;
        private final CountDownLatch latch;

        protected ConsoleConsumer(InputStream in, String shutdownId) {
            this.in = in;
            this.latch = new CountDownLatch(1);
            this.shutdownId = shutdownId;
        }

        @Override
        public void run() {
            try {
                int num;
                byte[] buf = new byte[512];
                while ((num = this.in.read(buf)) != -1) {
                    System.out.write(buf, 0, num);
                    if (this.shutdownId == null || !new String(buf).contains(this.shutdownId)) continue;
                    this.latch.countDown();
                    if (!Server.this.isRunning()) continue;
                    Server.this.stop();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        void awaitShutdown(long seconds) throws InterruptedException {
            if (this.shutdownId == null) {
                this.latch.countDown();
            }
            this.latch.await(seconds, TimeUnit.SECONDS);
        }
    }

    private class Reaper
    implements Runnable {
        private Reaper() {
        }

        @Override
        public void run() {
            Server.this.checkServerState();
            if (!Server.this.isRunning()) {
                Server.this.stop();
            }
        }
    }
}

