/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.plugin.server;

import java.io.File;
import java.util.List;
import org.jboss.as.plugin.common.ConnectionInfo;
import org.jboss.as.plugin.common.Files;
import org.jboss.as.plugin.server.Arguments;

class ServerConfig {
    private static final String SERVER_BASE_DIR = "jboss.server.base.dir";
    private static final String SERVER_CONFIG_DIR = "jboss.server.config.dir";
    private static final String SERVER_LOG_DIR = "jboss.server.log.dir";
    private final ConnectionInfo connectionInfo;
    private final File jbossHome;
    private String modulesDir;
    private String bundlesDir;
    private final Arguments jvmArgs;
    private String javaHome;
    private String serverConfig;
    private String propertiesFile;
    private final Arguments serverArgs;
    private long startupTimeout;
    private String baseDir;
    private String configDir;
    private String logDir;

    ServerConfig(ConnectionInfo connectionInfo, File jbossHome) {
        this.connectionInfo = connectionInfo;
        this.jbossHome = jbossHome;
        this.jvmArgs = new Arguments();
        this.serverArgs = new Arguments();
        this.startupTimeout = 60L;
    }

    public static ServerConfig of(ConnectionInfo connectionInfo, File jbossHome) {
        return new ServerConfig(connectionInfo, jbossHome);
    }

    public ConnectionInfo getConnectionInfo() {
        return this.connectionInfo;
    }

    public File getJbossHome() {
        return this.jbossHome;
    }

    public String getModulesDir() {
        return this.modulesDir == null ? Files.createPath(this.jbossHome, "modules") : this.modulesDir;
    }

    public ServerConfig setModulesDir(String modulesDir) {
        this.modulesDir = modulesDir;
        return this;
    }

    public String getBundlesDir() {
        return this.bundlesDir == null ? Files.createPath(this.jbossHome, "bundles") : this.bundlesDir;
    }

    public ServerConfig setBundlesDir(String bundlesDir) {
        this.bundlesDir = bundlesDir;
        return this;
    }

    public List<String> getJvmArgs() {
        return this.jvmArgs.asList();
    }

    public ServerConfig addJvmArg(String arg) {
        Arguments.Argument argument = Arguments.parse(arg);
        if (SERVER_BASE_DIR.equals(argument.getKey())) {
            this.baseDir = argument.getValue();
        } else if (SERVER_CONFIG_DIR.equals(argument.getKey())) {
            this.configDir = argument.getValue();
        } else if (SERVER_LOG_DIR.equals(argument.getKey())) {
            this.logDir = argument.getValue();
        }
        this.jvmArgs.add(argument);
        return this;
    }

    public ServerConfig setJvmArgs(String ... jvmArgs) {
        this.jvmArgs.clear();
        for (String arg : jvmArgs) {
            this.addJvmArg(arg);
        }
        return this;
    }

    public String getJavaHome() {
        return this.javaHome;
    }

    public ServerConfig setJavaHome(String javaHome) {
        this.javaHome = javaHome;
        return this;
    }

    public String getServerConfig() {
        return this.serverConfig;
    }

    public ServerConfig setServerConfig(String serverConfig) {
        this.serverConfig = serverConfig;
        return this;
    }

    public String getPropertiesFile() {
        return this.propertiesFile;
    }

    public ServerConfig setPropertiesFile(String propertiesFile) {
        this.propertiesFile = propertiesFile;
        return this;
    }

    public List<String> getServerArgs() {
        return this.serverArgs.asList();
    }

    public ServerConfig addServerArg(String arg) {
        Arguments.Argument argument = Arguments.parse(arg);
        if (SERVER_BASE_DIR.equals(argument.getKey())) {
            this.baseDir = argument.getValue();
        } else if (SERVER_CONFIG_DIR.equals(argument.getKey())) {
            this.configDir = argument.getValue();
        } else if (SERVER_LOG_DIR.equals(argument.getKey())) {
            this.logDir = argument.getValue();
        }
        this.serverArgs.add(argument);
        return this;
    }

    public ServerConfig setServerArgs(String ... serverArgs) {
        this.serverArgs.clear();
        for (String arg : serverArgs) {
            this.addServerArg(arg);
        }
        return this;
    }

    public long getStartupTimeout() {
        return this.startupTimeout;
    }

    public ServerConfig setStartupTimeout(long startupTimeout) {
        this.startupTimeout = startupTimeout;
        return this;
    }

    public String getBaseDir() {
        return this.baseDir == null ? Files.createPath(this.jbossHome, "standalone") : this.baseDir;
    }

    public String getConfigDir() {
        return this.configDir == null ? Files.createPath(this.getBaseDir(), "configuration") : this.configDir;
    }

    public String getLogDir() {
        return this.logDir == null ? Files.createPath(this.getBaseDir(), "log") : this.logDir;
    }
}

