/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment.plugin;

import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;
import org.jboss.metadata.ejb.jboss.jndipolicy.spi.DefaultJndiBindingPolicy;
import org.jboss.metadata.ejb.jboss.jndipolicy.spi.EjbDeploymentSummary;
import org.jboss.metadata.ejb.jboss.jndipolicy.spi.KnownInterfaces;

public class LegacyEjb3JndiPolicy
implements DefaultJndiBindingPolicy {
    private static Logger log = Logger.getLogger(LegacyEjb3JndiPolicy.class);
    private String baseJndiName;

    public LegacyEjb3JndiPolicy() {
    }

    public LegacyEjb3JndiPolicy(String baseJndiName) {
        this.baseJndiName = baseJndiName;
    }

    public String getBaseJndiName() {
        return this.baseJndiName;
    }

    public void setBaseJndiName(String baseJndiName) {
        this.baseJndiName = baseJndiName;
    }

    public String getDefaultLocalHomeJndiName(EjbDeploymentSummary summary) {
        return this.baseJndiName + "/" + "localHome";
    }

    public String getDefaultLocalJndiName(EjbDeploymentSummary summary) {
        return this.baseJndiName + "/" + "local";
    }

    public String getDefaultRemoteHomeJndiName(EjbDeploymentSummary summary) {
        return this.baseJndiName + "/" + "home";
    }

    public String getDefaultRemoteJndiName(EjbDeploymentSummary summary) {
        return this.baseJndiName + "/" + "remote";
    }

    public String getJndiName(EjbDeploymentSummary summary) {
        return this.baseJndiName;
    }

    public String getJndiName(EjbDeploymentSummary summary, String iface, KnownInterfaces.KnownInterfaceType ifaceType) {
        String appName;
        JBossSessionBeanMetaData sbeanMD;
        String givenJndiName;
        JBossEnterpriseBeanMetaData beanMD = summary.getBeanMD();
        this.baseJndiName = beanMD.getMappedName();
        if (this.baseJndiName == null) {
            this.baseJndiName = beanMD.determineJndiName();
        }
        String jndiName = null;
        String localJndiName = beanMD.getLocalJndiName();
        boolean is3x = beanMD.getJBossMetaData().isEJB3x();
        boolean hasJndiName = false;
        if (beanMD.isSession() && (givenJndiName = (sbeanMD = (JBossSessionBeanMetaData)beanMD).getJndiName()) != null && givenJndiName.trim().length() > 0) {
            hasJndiName = true;
        }
        appName = (appName = summary.getDeploymentScopeBaseName()) == null ? "" : appName + "/";
        String ejbName = beanMD.getEjbName();
        switch (ifaceType) {
            case BUSINESS_LOCAL: {
                if (localJndiName == null) {
                    jndiName = appName + ejbName + "/local";
                    break;
                }
                jndiName = localJndiName;
                break;
            }
            case BUSINESS_REMOTE: {
                if (!hasJndiName) {
                    jndiName = appName + ejbName + "/remote";
                    break;
                }
                jndiName = this.baseJndiName;
                break;
            }
            case LOCAL_HOME: {
                if (is3x) {
                    log.warn((Object)("Requested ejb3 local home for bean: " + beanMD.getEjbName()));
                    jndiName = ejbName + "/localHome";
                    break;
                }
                jndiName = beanMD.determineLocalJndiName();
                break;
            }
            case REMOTE_HOME: {
                if (is3x) {
                    if (!hasJndiName) {
                        jndiName = ejbName + "/home";
                        break;
                    }
                    jndiName = this.baseJndiName;
                    break;
                }
                jndiName = this.baseJndiName;
                break;
            }
            case UNKNOWN: {
                if (iface != null) {
                    log.warn((Object)("UKNOWN iface seen: " + iface + ", for bean: " + beanMD.getEjbName()));
                }
                jndiName = this.baseJndiName;
            }
        }
        return jndiName;
    }
}

