/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.jmx;

import java.security.Principal;
import javax.management.remote.JMXAuthenticator;
import javax.management.remote.JMXPrincipal;
import javax.security.auth.Subject;
import org.jboss.security.AuthenticationManager;
import org.jboss.security.SecurityContext;
import org.picketbox.factories.SecurityFactory;

class JMXConnectorAuthenticator
implements JMXAuthenticator {
    String securityDomainName;

    JMXConnectorAuthenticator(String securityDomainName) {
        this.securityDomainName = securityDomainName;
    }

    public synchronized Subject authenticate(Object creds) {
        if (creds == null) {
            throw new SecurityException("JMXConnectorAuthenticator requires userid/password credentials to be passed in");
        }
        if (!(creds instanceof String[])) {
            throw new SecurityException("JMXConnectorAuthenticator can only handle authentication parameter that is array of two strings, instead got " + creds.getClass().getName());
        }
        String[] pair = (String[])creds;
        if (pair.length != 2) {
            throw new SecurityException("JMXConnectorAuthenticator can only handle authentication parameter that is array of two strings, instead got " + pair.length + " strings");
        }
        String user = pair[0];
        String pass = pair[1];
        JMXPrincipal principal = new JMXPrincipal(user);
        Subject subject = new Subject();
        SecurityContext securityContext = SecurityFactory.establishSecurityContext((String)this.securityDomainName);
        AuthenticationManager am = securityContext.getAuthenticationManager();
        boolean result = am.isValid((Principal)principal, (Object)pass, subject);
        if (!result) {
            throw new SecurityException("user authentication check failed");
        }
        subject.setReadOnly();
        return subject;
    }
}

