/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.persistence.deployer;

import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.logging.Logger;
import org.jboss.profileservice.persistence.PersistenceFactory;
import org.jboss.profileservice.persistence.repository.PersistenceRepository;
import org.jboss.profileservice.persistence.repository.metadata.AttachmentMetaData;
import org.jboss.profileservice.persistence.repository.metadata.RepositoryAttachmentMetaData;
import org.jboss.profileservice.persistence.xml.PersistenceRoot;
import org.jboss.system.server.profileservice.persistence.deployer.PersistenceModificationChecker;

public class ProfileServicePersistenceDeployer
extends AbstractRealDeployer {
    public static final String PERSISTED_ATTACHMENT_PREFIX = "PERISTED";
    private PersistenceRepository persistenceRepository;
    private static final Logger log = Logger.getLogger(ProfileServicePersistenceDeployer.class);

    public ProfileServicePersistenceDeployer() {
        this.setAllInputs(true);
        this.setStage(DeploymentStages.PRE_REAL);
    }

    public PersistenceRepository getPersistenceRepository() {
        return this.persistenceRepository;
    }

    public void setPersistenceRepository(PersistenceRepository persistenceRepository) {
        this.persistenceRepository = persistenceRepository;
    }

    protected void internalDeploy(DeploymentUnit unit) throws DeploymentException {
        if (unit == null || !(unit instanceof VFSDeploymentUnit)) {
            return;
        }
        try {
            this.applyPersistentChanges((VFSDeploymentUnit)VFSDeploymentUnit.class.cast(unit));
        }
        catch (Throwable e) {
            log.warn((Object)"Failed to update the persisted attachment information", e);
        }
    }

    protected void applyPersistentChanges(VFSDeploymentUnit unit) throws Throwable {
        String deploymentName = unit.getName();
        String simpleName = unit.getSimpleName();
        RepositoryAttachmentMetaData metaData = this.getPersistenceRepository().loadMetaData(deploymentName, simpleName);
        if (metaData == null) {
            return;
        }
        if (PersistenceModificationChecker.hasBeenModified(unit, metaData.getLastModified())) {
            log.debug((Object)("Deployment was modified, not applying persisted information : " + unit));
            return;
        }
        if (metaData.getAttachments() != null && !metaData.getAttachments().isEmpty()) {
            for (AttachmentMetaData attachment : metaData.getAttachments()) {
                Object instance = unit.getAttachment(attachment.getName());
                if (instance != null) {
                    PersistenceRoot root = this.getPersistenceRepository().loadAttachment(deploymentName, simpleName, attachment);
                    if (root == null) {
                        log.warn((Object)("Null persisted information for deployment: " + deploymentName));
                    }
                    this.getPersistenceFactory().restorePersistenceRoot(root, instance, unit.getClassLoader());
                    continue;
                }
                log.warn((Object)("Could not apply changes, failed to find attachment: " + attachment.getName()));
            }
        }
    }

    private PersistenceFactory getPersistenceFactory() {
        return this.getPersistenceRepository().getPersistenceFactory();
    }
}

