/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.repository.clustered.local;

import java.io.File;
import java.io.NotSerializableException;
import org.jboss.logging.Logger;
import org.jboss.system.server.profileservice.repository.clustered.local.ContentMetadataPersister;
import org.jboss.system.server.profileservice.repository.clustered.metadata.RepositoryContentMetadata;

public abstract class AbstractContentMetadataPersister
implements ContentMetadataPersister {
    private static final Logger log = Logger.getLogger(AbstractContentMetadataPersister.class);
    private final File contentMetadataDir;

    public AbstractContentMetadataPersister(File dir) {
        if (dir == null) {
            throw new IllegalArgumentException("Null store dir.");
        }
        this.contentMetadataDir = dir;
    }

    public RepositoryContentMetadata load(String baseName) {
        File attachmentsStore = this.getMetadataPath(baseName);
        if (!attachmentsStore.exists()) {
            return null;
        }
        try {
            return this.loadMetadata(attachmentsStore);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void store(String baseName, RepositoryContentMetadata metadata) {
        File attachmentsStore = this.getMetadataPath(baseName);
        File attachmentsParent = attachmentsStore.getParentFile();
        if (!attachmentsParent.exists() && !attachmentsParent.mkdirs()) {
            throw new RuntimeException("Failed to create attachmentsParent: " + attachmentsParent.getAbsolutePath());
        }
        if (metadata != null) {
            try {
                this.saveMetadata(attachmentsStore, metadata);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (NotSerializableException e) {
                StringBuilder tmp = new StringBuilder("Save failed with NSE, attachments contents: ");
                tmp.append(metadata).append(" to: ").append(attachmentsStore);
                log.error((Object)tmp.toString());
                throw new RuntimeException(e);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public abstract File getMetadataPath(String var1);

    protected abstract RepositoryContentMetadata loadMetadata(File var1) throws Exception;

    protected abstract void saveMetadata(File var1, RepositoryContentMetadata var2) throws Exception;

    protected File getContentMetadataDir() {
        return this.contentMetadataDir;
    }
}

