/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.server.profileservice.repository.clustered.sync;

import java.io.Serializable;

public class ByteChunk
implements Serializable {
    private static final long serialVersionUID = -1278778998152090786L;
    private final int byteCount;
    private final byte[] bytes;

    public ByteChunk(byte[] bytes, int byteCount) {
        if (bytes == null) {
            throw new IllegalArgumentException("Null bytes");
        }
        if (byteCount < 0) {
            this.byteCount = -1;
            this.bytes = null;
        } else {
            this.byteCount = byteCount;
            int diff = bytes.length - byteCount;
            if (diff > 10240 && diff > bytes.length / 4) {
                this.bytes = new byte[byteCount];
                System.arraycopy(bytes, 0, this.bytes, 0, byteCount);
            } else {
                this.bytes = bytes;
            }
        }
    }

    public int getByteCount() {
        return this.byteCount;
    }

    public byte[] getBytes() {
        return this.bytes;
    }
}

