/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudservers.compute.functions;

import com.google.common.base.Function;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.cloudservers.domain.Image;
import org.jclouds.compute.domain.ImageBuilder;
import org.jclouds.compute.domain.OperatingSystem;
import org.jclouds.domain.Credentials;

@Singleton
public class CloudServersImageToImage
implements Function<Image, org.jclouds.compute.domain.Image> {
    private final Function<Image, OperatingSystem> imageToOs;

    @Inject
    CloudServersImageToImage(Function<Image, OperatingSystem> imageToOs) {
        this.imageToOs = imageToOs;
    }

    public org.jclouds.compute.domain.Image apply(Image from) {
        ImageBuilder builder = new ImageBuilder();
        builder.ids(from.getId() + "");
        builder.name(from.getName());
        builder.description(from.getName());
        builder.version(from.getUpdated().getTime() + "");
        builder.operatingSystem((OperatingSystem)this.imageToOs.apply((Object)from));
        builder.defaultCredentials(new Credentials("root", null));
        org.jclouds.compute.domain.Image image = builder.build();
        return image;
    }
}

