/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudservers.compute.strategy;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.cloudservers.CloudServersClient;
import org.jclouds.cloudservers.domain.Server;
import org.jclouds.cloudservers.options.CreateServerOptions;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.domain.Template;
import org.jclouds.compute.strategy.CreateNodeWithGroupEncodedIntoName;
import org.jclouds.domain.Credentials;

@Singleton
public class CloudServersCreateNodeWithGroupEncodedIntoName
implements CreateNodeWithGroupEncodedIntoName {
    protected final CloudServersClient client;
    protected final Map<String, Credentials> credentialStore;
    protected final Function<Server, NodeMetadata> serverToNodeMetadata;

    @Inject
    protected CloudServersCreateNodeWithGroupEncodedIntoName(CloudServersClient client, Map<String, Credentials> credentialStore, Function<Server, NodeMetadata> serverToNodeMetadata) {
        this.client = (CloudServersClient)Preconditions.checkNotNull((Object)client, (Object)"client");
        this.credentialStore = (Map)Preconditions.checkNotNull(credentialStore, (Object)"credentialStore");
        this.serverToNodeMetadata = (Function)Preconditions.checkNotNull(serverToNodeMetadata, (Object)"serverToNodeMetadata");
    }

    public NodeMetadata createNodeWithGroupEncodedIntoName(String group, String name, Template template) {
        Server from = this.client.createServer(name, Integer.parseInt(template.getImage().getProviderId()), Integer.parseInt(template.getHardware().getProviderId()), new CreateServerOptions[0]);
        this.credentialStore.put("node#" + from.getId(), new Credentials("root", from.getAdminPass()));
        return (NodeMetadata)this.serverToNodeMetadata.apply((Object)from);
    }
}

