/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.cloudservers.compute.strategy;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.cloudservers.CloudServersClient;
import org.jclouds.cloudservers.domain.Server;
import org.jclouds.cloudservers.options.ListOptions;
import org.jclouds.compute.domain.ComputeMetadata;
import org.jclouds.compute.domain.NodeMetadata;
import org.jclouds.compute.predicates.NodePredicates;
import org.jclouds.compute.strategy.ListNodesStrategy;

@Singleton
public class CloudServersListNodesStrategy
implements ListNodesStrategy {
    private final CloudServersClient client;
    private final Function<Server, NodeMetadata> serverToNodeMetadata;

    @Inject
    protected CloudServersListNodesStrategy(CloudServersClient client, Function<Server, NodeMetadata> serverToNodeMetadata) {
        this.client = client;
        this.serverToNodeMetadata = serverToNodeMetadata;
    }

    public Iterable<? extends ComputeMetadata> listNodes() {
        return this.listDetailsOnNodesMatching((Predicate<ComputeMetadata>)NodePredicates.all());
    }

    public Iterable<? extends NodeMetadata> listDetailsOnNodesMatching(Predicate<ComputeMetadata> filter) {
        return Iterables.filter((Iterable)Iterables.transform(this.client.listServers(ListOptions.Builder.withDetails()), this.serverToNodeMetadata), filter);
    }
}

