/**
 *
 * Copyright (C) 2011 Cloud Conscious, LLC. <info@cloudconscious.com>
 *
 * ====================================================================
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * ====================================================================
 */
package org.jclouds.vcloud.options;

import static com.google.common.base.Preconditions.checkNotNull;

/**
 * 
 * @author Adrian Cole
 * 
 */
public class CloneOptions {

   private String description;

   /**
    * the clone should be powered on after it is deployed
    */
   public CloneOptions description(String description) {
      checkNotNull(description, "description");
      this.description = description;
      return this;
   }

   public String getDescription() {
      return description;
   }

   public static class Builder {

      /**
       * @see CloneOptions#description(String)
       */
      public static CloneOptions description(String description) {
         return new CloneOptions().description(description);
      }
   }

}
