/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.azure.storage.filters;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.io.InputSupplier;
import java.util.Collection;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.annotation.Resource;
import javax.crypto.Mac;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.jclouds.crypto.Crypto;
import org.jclouds.crypto.CryptoStreams;
import org.jclouds.date.TimeStamp;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.internal.SignatureWire;
import org.jclouds.http.utils.ModifyRequest;
import org.jclouds.io.InputSuppliers;
import org.jclouds.logging.Logger;
import org.jclouds.rest.annotations.Credential;
import org.jclouds.rest.annotations.Identity;
import org.jclouds.util.Patterns;
import org.jclouds.util.Strings2;

@Singleton
public class SharedKeyLiteAuthentication
implements HttpRequestFilter {
    private static final Collection<String> FIRST_HEADERS_TO_SIGN = ImmutableList.of((Object)"Date");
    private final SignatureWire signatureWire;
    private final String identity;
    private final byte[] key;
    private final Provider<String> timeStampProvider;
    private final Crypto crypto;
    private final HttpUtils utils;
    @Resource
    @Named(value="jclouds.signature")
    Logger signatureLog = Logger.NULL;

    @Inject
    public SharedKeyLiteAuthentication(SignatureWire signatureWire, @Identity String identity, @Credential String encodedKey, @TimeStamp Provider<String> timeStampProvider, Crypto crypto, HttpUtils utils) {
        this.crypto = crypto;
        this.utils = utils;
        this.signatureWire = signatureWire;
        this.identity = identity;
        this.key = CryptoStreams.base64((String)encodedKey);
        this.timeStampProvider = timeStampProvider;
    }

    public HttpRequest filter(HttpRequest request) throws HttpException {
        request = this.replaceDateHeader(request);
        String signature = this.calculateSignature(this.createStringToSign(request));
        request = this.replaceAuthorizationHeader(request, signature);
        this.utils.logRequest(this.signatureLog, request, "<<");
        return request;
    }

    HttpRequest replaceAuthorizationHeader(HttpRequest request, String signature) {
        return ModifyRequest.replaceHeader((HttpRequest)request, (String)"Authorization", (String[])new String[]{"SharedKeyLite " + this.identity + ":" + signature});
    }

    HttpRequest replaceDateHeader(HttpRequest request) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        String date = (String)this.timeStampProvider.get();
        builder.put((Object)"Date", (Object)date);
        request = ModifyRequest.replaceHeaders((HttpRequest)request, (Multimap)Multimaps.forMap((Map)builder.build()));
        return request;
    }

    public String createStringToSign(HttpRequest request) {
        this.utils.logRequest(this.signatureLog, request, ">>");
        StringBuilder buffer = new StringBuilder();
        this.appendMethod(request, buffer);
        this.appendPayloadMetadata(request, buffer);
        this.appendHttpHeaders(request, buffer);
        this.appendCanonicalizedHeaders(request, buffer);
        this.appendCanonicalizedResource(request, buffer);
        if (this.signatureWire.enabled()) {
            this.signatureWire.output((Object)buffer.toString());
        }
        return buffer.toString();
    }

    private void appendPayloadMetadata(HttpRequest request, StringBuilder buffer) {
        buffer.append(HttpUtils.nullToEmpty(request.getPayload() == null ? null : request.getPayload().getContentMetadata().getContentMD5())).append("\n");
        buffer.append(Strings.nullToEmpty(request.getPayload() == null ? null : request.getPayload().getContentMetadata().getContentType())).append("\n");
    }

    private String calculateSignature(String toSign) throws HttpException {
        String signature = this.signString(toSign);
        if (this.signatureWire.enabled()) {
            this.signatureWire.input(Strings2.toInputStream((String)signature));
        }
        return signature;
    }

    public String signString(String toSign) {
        String signature;
        try {
            signature = CryptoStreams.base64((byte[])CryptoStreams.mac((InputSupplier)InputSuppliers.of((String)toSign), (Mac)this.crypto.hmacSHA256(this.key)));
        }
        catch (Exception e) {
            throw new HttpException("error signing request", (Throwable)e);
        }
        return signature;
    }

    private void appendMethod(HttpRequest request, StringBuilder toSign) {
        toSign.append(request.getMethod()).append("\n");
    }

    private void appendCanonicalizedHeaders(HttpRequest request, StringBuilder toSign) {
        TreeSet headers = new TreeSet(request.getHeaders().keySet());
        for (String header : headers) {
            if (!header.startsWith("x-ms-")) continue;
            toSign.append(header.toLowerCase()).append(":");
            for (String value : request.getHeaders().get((Object)header)) {
                toSign.append(Strings2.replaceAll((String)value, (Pattern)Patterns.NEWLINE_PATTERN, (String)"")).append(",");
            }
            toSign.deleteCharAt(toSign.lastIndexOf(","));
            toSign.append("\n");
        }
    }

    private void appendHttpHeaders(HttpRequest request, StringBuilder toSign) {
        for (String header : FIRST_HEADERS_TO_SIGN) {
            toSign.append(HttpUtils.nullToEmpty((Collection)request.getHeaders().get((Object)header))).append("\n");
        }
    }

    @VisibleForTesting
    void appendCanonicalizedResource(HttpRequest request, StringBuilder toSign) {
        toSign.append("/").append(this.identity);
        this.appendUriPath(request, toSign);
    }

    @VisibleForTesting
    void appendUriPath(HttpRequest request, StringBuilder toSign) {
        toSign.append(request.getEndpoint().getRawPath());
        if (request.getEndpoint().getQuery() != null) {
            String[] params;
            StringBuilder paramsToSign = new StringBuilder("?");
            for (String param : params = request.getEndpoint().getQuery().split("&")) {
                String[] paramNameAndValue = param.split("=");
                if (!"comp".equals(paramNameAndValue[0])) continue;
                paramsToSign.append(param);
            }
            if (paramsToSign.length() > 1) {
                toSign.append((CharSequence)paramsToSign);
            }
        }
    }
}

