/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.functions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.security.MessageDigest;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.crypto.Crypto;
import org.jclouds.http.HttpMessage;
import org.jclouds.io.PayloadEnclosing;
import org.jclouds.io.Payloads;

@Singleton
public class ObjectMD5
implements Function<Object, byte[]> {
    protected final Crypto crypto;

    @Inject
    ObjectMD5(Crypto crypto) {
        this.crypto = (Crypto)Preconditions.checkNotNull((Object)crypto, (Object)"crypto");
    }

    public byte[] apply(Object from) {
        Preconditions.checkNotNull((Object)from, (Object)"thing to md5");
        Object payloadEnclosing = from instanceof PayloadEnclosing ? (PayloadEnclosing)from : HttpMessage.builder().payload(Payloads.newPayload((Object)from)).build();
        if (payloadEnclosing.getPayload().getContentMetadata().getContentMD5() == null) {
            try {
                Payloads.calculateMD5((PayloadEnclosing)payloadEnclosing, (MessageDigest)this.crypto.md5());
            }
            catch (IOException e) {
                Throwables.propagate((Throwable)e);
            }
        }
        return payloadEnclosing.getPayload().getContentMetadata().getContentMD5();
    }
}

