/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.easymock.EasyMock;
import org.jclouds.ContextBuilder;
import org.jclouds.blobstore.BlobStore;
import org.jclouds.blobstore.BlobStoreContext;
import org.jclouds.blobstore.BlobStores;
import org.jclouds.blobstore.ContainerNotFoundException;
import org.jclouds.blobstore.domain.StorageMetadata;
import org.jclouds.blobstore.domain.internal.PageSetImpl;
import org.jclouds.blobstore.options.ListAllOptions;
import org.jclouds.blobstore.options.ListContainerOptions;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(singleThreaded=true, testName="BlobStoresTest")
public class BlobStoresTest {
    private final String containerName = "mycontainer";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={ContainerNotFoundException.class})
    public void testListAllForUnknownContainerFromTransientBlobStoreEagerly() throws Exception {
        ListContainerOptions.ImmutableListContainerOptions containerOptions = ListContainerOptions.NONE;
        ListAllOptions listAllOptions = ListAllOptions.Builder.eager((boolean)true);
        BlobStoreContext context = this.blobStoreContext();
        try {
            BlobStore blobStore = context.getBlobStore();
            BlobStores.listAll((BlobStore)blobStore, (String)"wrongcontainer", (ListContainerOptions)containerOptions, (ListAllOptions)listAllOptions);
        }
        finally {
            context.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expectedExceptions={ContainerNotFoundException.class})
    public void testListAllForUnknownContainerFromTransientBlobStore() throws Exception {
        ListContainerOptions.ImmutableListContainerOptions options = ListContainerOptions.NONE;
        BlobStoreContext context = this.blobStoreContext();
        try {
            BlobStore blobStore = context.getBlobStore();
            Iterable iterable = BlobStores.listAll((BlobStore)blobStore, (String)"wrongcontainer", (ListContainerOptions)options);
            iterable.iterator().hasNext();
        }
        finally {
            context.close();
        }
    }

    protected BlobStoreContext blobStoreContext() {
        return (BlobStoreContext)ContextBuilder.newBuilder((String)"transient").build(BlobStoreContext.class);
    }

    @Test
    public void testListAllFromTransientBlobStore() throws Exception {
        this.runListAllFromTransientBlobStore(false);
    }

    @Test
    public void testListAllFromTransientBlobStoreEagerly() throws Exception {
        this.runListAllFromTransientBlobStore(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runListAllFromTransientBlobStore(boolean eager) throws Exception {
        int numTimesToIterate = 2;
        int NUM_BLOBS = 31;
        ListContainerOptions containerOptions = ListContainerOptions.Builder.maxResults((int)10);
        BlobStoreContext context = this.blobStoreContext();
        BlobStore blobStore = null;
        try {
            blobStore = context.getBlobStore();
            blobStore.createContainerInLocation(null, "mycontainer");
            HashSet<String> expectedNames = new HashSet<String>();
            for (int i = 0; i < 31; ++i) {
                String blobName = "myname" + i;
                blobStore.putBlob("mycontainer", blobStore.blobBuilder(blobName).payload("payload" + i).build());
                expectedNames.add(blobName);
            }
            ListAllOptions listAllOptions = ListAllOptions.Builder.eager((boolean)eager);
            Iterable iterable = BlobStores.listAll((BlobStore)blobStore, (String)"mycontainer", (ListContainerOptions)containerOptions, (ListAllOptions)listAllOptions);
            for (int i = 0; i < 2; ++i) {
                Iterable iterableNames = Iterables.transform((Iterable)iterable, (Function)new Function<StorageMetadata, String>(){

                    public String apply(StorageMetadata input) {
                        return input.getName();
                    }
                });
                Assert.assertEquals((Set)ImmutableSet.copyOf((Iterable)iterableNames), expectedNames);
            }
        }
        finally {
            if (blobStore != null) {
                blobStore.deleteContainer("mycontainer");
            }
            context.close();
        }
    }

    @Test
    public void testListAllWhenOnePage() throws Exception {
        BlobStore blobStore = (BlobStore)EasyMock.createMock(BlobStore.class);
        ListContainerOptions.ImmutableListContainerOptions options = ListContainerOptions.NONE;
        StorageMetadata v1 = (StorageMetadata)EasyMock.createMock(StorageMetadata.class);
        PageSetImpl pageSet = new PageSetImpl(Collections.singletonList(v1), null);
        EasyMock.expect((Object)blobStore.list("mycontainer", (ListContainerOptions)options)).andReturn((Object)pageSet).once();
        EasyMock.replay((Object[])new Object[]{blobStore});
        Iterable iterable = BlobStores.listAll((BlobStore)blobStore, (String)"mycontainer", (ListContainerOptions)options);
        Assert.assertEquals((Collection)ImmutableList.copyOf((Iterable)iterable), (Collection)ImmutableList.of((Object)v1));
    }

    @Test
    public void testListAllWhenTwoPages() throws Exception {
        BlobStore blobStore = (BlobStore)EasyMock.createMock(BlobStore.class);
        ListContainerOptions.ImmutableListContainerOptions options = ListContainerOptions.NONE;
        ListContainerOptions options2 = ListContainerOptions.Builder.afterMarker((String)"marker1");
        StorageMetadata v1 = (StorageMetadata)EasyMock.createMock(StorageMetadata.class);
        StorageMetadata v2 = (StorageMetadata)EasyMock.createMock(StorageMetadata.class);
        PageSetImpl pageSet = new PageSetImpl(Collections.singletonList(v1), "marker1");
        PageSetImpl pageSet2 = new PageSetImpl(Collections.singletonList(v2), null);
        EasyMock.expect((Object)blobStore.list("mycontainer", (ListContainerOptions)options)).andReturn((Object)pageSet).once();
        EasyMock.expect((Object)blobStore.list("mycontainer", options2)).andReturn((Object)pageSet2).once();
        EasyMock.replay((Object[])new Object[]{blobStore});
        Iterable iterable = BlobStores.listAll((BlobStore)blobStore, (String)"mycontainer", (ListContainerOptions)options);
        Assert.assertEquals((Collection)ImmutableList.copyOf((Iterable)iterable), (Collection)ImmutableList.of((Object)v1, (Object)v2));
    }
}

