/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore;

import com.google.inject.TypeLiteral;
import java.io.IOException;
import javax.inject.Provider;
import org.jclouds.apis.ApiMetadata;
import org.jclouds.blobstore.BlobRequestSigner;
import org.jclouds.blobstore.TransientApiMetadata;
import org.jclouds.blobstore.TransientAsyncBlobStore;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.blobstore.domain.BlobBuilder;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.internal.BaseAsyncClientTest;
import org.jclouds.rest.internal.RestAnnotationProcessor;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="TransientBlobRequestSignerTest")
public class TransientBlobRequestSignerTest
extends BaseAsyncClientTest<TransientAsyncBlobStore> {
    private BlobRequestSigner signer;
    private Provider<BlobBuilder> blobFactory;
    private final String endpoint = (String)new TransientApiMetadata().getDefaultEndpoint().get();
    private final String containerName = "container";
    private final String blobName = "blob";
    private final String fullUrl = String.format("%s/%s/%s", this.endpoint, "container", "blob");

    public void testSignGetBlob() throws ArrayIndexOutOfBoundsException, SecurityException, IllegalArgumentException, NoSuchMethodException, IOException {
        HttpRequest request = this.signer.signGetBlob("container", "blob");
        this.assertRequestLineEquals(request, "GET " + this.fullUrl + " HTTP/1.1");
        this.assertNonPayloadHeadersEqual(request, "Authorization: Basic aWRlbnRpdHk6Y3JlZGVudGlhbA==\n");
        this.assertPayloadEquals(request, null, null, false);
        Assert.assertEquals((int)request.getFilters().size(), (int)0);
    }

    public void testSignRemoveBlob() throws ArrayIndexOutOfBoundsException, SecurityException, IllegalArgumentException, NoSuchMethodException, IOException {
        HttpRequest request = this.signer.signRemoveBlob("container", "blob");
        this.assertRequestLineEquals(request, "DELETE " + this.fullUrl + " HTTP/1.1");
        this.assertNonPayloadHeadersEqual(request, "Authorization: Basic aWRlbnRpdHk6Y3JlZGVudGlhbA==\n");
        this.assertPayloadEquals(request, null, null, false);
        Assert.assertEquals((int)request.getFilters().size(), (int)0);
    }

    public void testSignPutBlob() throws ArrayIndexOutOfBoundsException, SecurityException, IllegalArgumentException, NoSuchMethodException, IOException {
        Blob blob = ((BlobBuilder)this.blobFactory.get()).name("blob").forSigning().contentLength(2L).contentMD5(new byte[]{0, 2, 4, 8}).contentType("text/plain").build();
        Assert.assertEquals((byte[])blob.getPayload().getContentMetadata().getContentMD5(), (byte[])new byte[]{0, 2, 4, 8});
        HttpRequest request = this.signer.signPutBlob("container", blob);
        this.assertRequestLineEquals(request, "PUT " + this.fullUrl + " HTTP/1.1");
        this.assertNonPayloadHeadersEqual(request, "Authorization: Basic aWRlbnRpdHk6Y3JlZGVudGlhbA==\nContent-Length: 2\nContent-MD5: AAIECA==\nContent-Type: text/plain\n");
        this.assertContentHeadersEqual(request, "text/plain", null, null, null, 2L, new byte[]{0, 2, 4, 8}, null);
        Assert.assertEquals((int)request.getFilters().size(), (int)0);
    }

    public void testSignPutBlobWithGenerate() throws ArrayIndexOutOfBoundsException, SecurityException, IllegalArgumentException, NoSuchMethodException, IOException {
        Blob blob = ((BlobBuilder)this.blobFactory.get()).name("blob").payload("foo").calculateMD5().contentType("text/plain").build();
        byte[] md5 = new byte[]{-84, -67, 24, -37, 76, -62, -8, 92, -19, -17, 101, 79, -52, -60, -92, -40};
        Assert.assertEquals((byte[])blob.getPayload().getContentMetadata().getContentMD5(), (byte[])md5);
        HttpRequest request = this.signer.signPutBlob("container", blob);
        this.assertRequestLineEquals(request, "PUT " + this.fullUrl + " HTTP/1.1");
        this.assertNonPayloadHeadersEqual(request, "Authorization: Basic aWRlbnRpdHk6Y3JlZGVudGlhbA==\nContent-Length: 3\nContent-MD5: rL0Y20zC+Fzt72VPzMSk2A==\nContent-Type: text/plain\n");
        this.assertContentHeadersEqual(request, "text/plain", null, null, null, 3L, md5, null);
        Assert.assertEquals((int)request.getFilters().size(), (int)0);
    }

    @BeforeClass
    protected void setupFactory() throws IOException {
        super.setupFactory();
        this.blobFactory = this.injector.getProvider(BlobBuilder.class);
        this.signer = (BlobRequestSigner)this.injector.getInstance(BlobRequestSigner.class);
    }

    protected void checkFilters(HttpRequest request) {
    }

    protected TypeLiteral<RestAnnotationProcessor<TransientAsyncBlobStore>> createTypeLiteral() {
        return new TypeLiteral<RestAnnotationProcessor<TransientAsyncBlobStore>>(){};
    }

    public ApiMetadata createApiMetadata() {
        return new TransientApiMetadata();
    }
}

