/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.binders;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.jclouds.ContextBuilder;
import org.jclouds.blobstore.binders.BindBlobToMultipartForm;
import org.jclouds.blobstore.domain.Blob;
import org.jclouds.http.HttpRequest;
import org.jclouds.util.Strings2;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(testName="blobstore.BindBlobToMultipartFormTest")
public class BindBlobToMultipartFormTest {
    private static Blob.Factory blobProvider = (Blob.Factory)ContextBuilder.newBuilder((String)"transient").buildInjector().getInstance(Blob.Factory.class);
    public static final String EXPECTS;
    public static final Blob TEST_BLOB;

    public void testSinglePart() throws IOException {
        Assert.assertEquals((int)EXPECTS.length(), (int)113);
        BindBlobToMultipartForm binder = new BindBlobToMultipartForm();
        HttpRequest request = HttpRequest.builder().method("GET").endpoint("http://localhost:8001").build();
        binder.bindToRequest(request, (Object)TEST_BLOB);
        Assert.assertEquals((String)Strings2.toStringAndClose((InputStream)request.getPayload().getInput()), (String)EXPECTS);
        Assert.assertEquals((Object)request.getPayload().getContentMetadata().getContentLength(), (Object)new Long(113L));
        Assert.assertEquals((String)request.getPayload().getContentMetadata().getContentType(), (String)"multipart/form-data; boundary=--JCLOUDS--");
    }

    private static void addData(String boundary, String data, StringBuilder builder) {
        builder.append(boundary).append("\r\n");
        builder.append("Content-Disposition").append(": ").append("form-data; name=\"hello\"").append("\r\n");
        builder.append("Content-Type").append(": ").append("text/plain").append("\r\n");
        builder.append("\r\n");
        builder.append(data).append("\r\n");
    }

    @Test(expectedExceptions={IllegalArgumentException.class})
    public void testMustBeBlob() {
        BindBlobToMultipartForm binder = new BindBlobToMultipartForm();
        HttpRequest request = HttpRequest.builder().method("POST").endpoint("http://localhost").build();
        binder.bindToRequest(request, (Object)new File("foo"));
    }

    @Test(expectedExceptions={NullPointerException.class, IllegalStateException.class})
    public void testNullIsBad() {
        BindBlobToMultipartForm binder = new BindBlobToMultipartForm();
        HttpRequest request = HttpRequest.builder().method("GET").endpoint("http://momma").build();
        binder.bindToRequest(request, null);
    }

    static {
        StringBuilder builder = new StringBuilder("--");
        BindBlobToMultipartFormTest.addData("--JCLOUDS--", "hello", builder);
        builder.append("--").append("--JCLOUDS--").append("--").append("\r\n");
        EXPECTS = builder.toString();
        TEST_BLOB = blobProvider.create(null);
        TEST_BLOB.getMetadata().setName("hello");
        TEST_BLOB.setPayload("hello");
        TEST_BLOB.getMetadata().getContentMetadata().setContentType("text/plain");
    }
}

