/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.functions;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import org.jclouds.blobstore.functions.ObjectMD5;
import org.jclouds.crypto.Crypto;
import org.jclouds.crypto.CryptoStreams;
import org.jclouds.encryption.internal.JCECrypto;
import org.jclouds.http.HttpMessage;
import org.jclouds.io.Payload;
import org.jclouds.io.Payloads;
import org.testng.Assert;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ObjectMD5Test {
    private ObjectMD5 fn = new ObjectMD5((Crypto)new JCECrypto());

    @Test
    public void testAlreadyHasMD5() {
        Payload payload = Payloads.newPayload((Object)"foo");
        payload.getContentMetadata().setContentMD5(new byte[0]);
        HttpMessage payloadEnclosing = HttpMessage.builder().payload(payload).build();
        Assert.assertEquals((byte[])this.fn.apply((Object)payloadEnclosing), (byte[])new byte[0]);
    }

    @Test
    public void testMD5PayloadEnclosing() throws IOException {
        Payload payload = Payloads.newPayload((Object)"foo");
        HttpMessage payloadEnclosing = HttpMessage.builder().payload(payload).build();
        Assert.assertEquals((byte[])this.fn.apply((Object)payloadEnclosing), (byte[])CryptoStreams.md5((byte[])"foo".getBytes()));
    }

    @Test
    public void testMD5String() throws IOException {
        Assert.assertEquals((byte[])this.fn.apply((Object)"foo"), (byte[])CryptoStreams.md5((byte[])"foo".getBytes()));
    }

    @Test(expectedExceptions={NullPointerException.class, IllegalStateException.class})
    public void testNullIsBad() {
        this.fn.apply(null);
    }
}

