/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.functions;

import org.jclouds.blobstore.ContainerNotFoundException;
import org.jclouds.blobstore.functions.ThrowContainerNotFoundOn404;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ThrowContainerNotFoundOn404Test {
    ThrowContainerNotFoundOn404 fn = new ThrowContainerNotFoundOn404();

    @Test(expectedExceptions={ContainerNotFoundException.class})
    public void testFound404ThrowsContainerNotFound() throws SecurityException, NoSuchMethodException {
        HttpResponse response = HttpResponse.builder().statusCode(404).build();
        HttpResponseException exception = new HttpResponseException(null, null, response);
        this.fn.apply((Exception)exception);
    }

    @Test(expectedExceptions={HttpResponseException.class})
    public void testNotFound404PropagatesHttpResponseException() throws SecurityException, NoSuchMethodException {
        HttpResponse response = HttpResponse.builder().statusCode(409).build();
        HttpResponseException exception = new HttpResponseException(null, null, response);
        this.fn.apply((Exception)exception);
    }

    @Test(expectedExceptions={RuntimeException.class})
    public void testNotFoundPropagates() throws SecurityException, NoSuchMethodException {
        this.fn.apply((Exception)new RuntimeException());
    }

    @Test(expectedExceptions={NullPointerException.class, IllegalStateException.class})
    public void testNullIsBad() {
        this.fn.apply(null);
    }
}

