/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.blobstore.functions;

import org.jclouds.blobstore.KeyNotFoundException;
import org.jclouds.blobstore.functions.ThrowKeyNotFoundOn404;
import org.jclouds.http.HttpResponse;
import org.jclouds.http.HttpResponseException;
import org.testng.annotations.Test;

@Test(groups={"unit"})
public class ThrowKeyNotFoundOn404Test {
    ThrowKeyNotFoundOn404 fn = new ThrowKeyNotFoundOn404();

    @Test(expectedExceptions={KeyNotFoundException.class})
    public void testFound404ThrowsKeyNotFound() throws SecurityException, NoSuchMethodException {
        HttpResponse response = HttpResponse.builder().statusCode(404).build();
        HttpResponseException exception = new HttpResponseException(null, null, response);
        this.fn.apply((Exception)exception);
    }

    @Test(expectedExceptions={HttpResponseException.class})
    public void testNotFound404PropagatesHttpResponseException() throws SecurityException, NoSuchMethodException {
        HttpResponse response = HttpResponse.builder().statusCode(409).build();
        HttpResponseException exception = new HttpResponseException(null, null, response);
        this.fn.apply((Exception)exception);
    }

    @Test(expectedExceptions={RuntimeException.class})
    public void testNotFoundPropagates() throws SecurityException, NoSuchMethodException {
        this.fn.apply((Exception)new RuntimeException());
    }

    @Test(expectedExceptions={NullPointerException.class, IllegalStateException.class})
    public void testNullIsBad() {
        this.fn.apply(null);
    }
}

